/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.venturecraft.gliders.VCGlidersClient;
import net.venturecraft.gliders.client.sound.MovingSound;
import net.venturecraft.gliders.util.GliderUtil;
import net.venturecraft.gliders.util.VCGliderTags;
import net.venturecraft.gliders.util.forge.ClientUtilImpl;

public class ClientUtil {
    public static boolean shouldChangePerspective = true;
    public static CameraType backupPerspective = Minecraft.m_91087_().f_91066_.m_92176_();

    public static void playPositionedSoundRecord(SoundEvent sound, float pitch, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void updraftParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_ || random.m_188503_(5) != 0) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !GliderUtil.isGlidingWithActiveGlider((LivingEntity)player)) {
            return;
        }
        if (!state.m_204336_(VCGliderTags.UPDRAFT_BLOCKS)) {
            return;
        }
        if (player.m_20238_(Vec3.m_82512_((Vec3i)pos)) > 64.0) {
            return;
        }
        level.m_6485_((ParticleOptions)ParticleTypes.f_175821_, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() * 2.0, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 1.0, 0.0);
    }

    public static void playGliderSound(Player player, ResourceLocation soundName, SoundSource category, boolean repeat, Supplier<Boolean> stopCondition, float volume, RandomSource randomSource) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new MovingSound(player, SoundEvent.m_262856_((ResourceLocation)soundName, (float)1.0f), category, repeat, stopCondition, volume, randomSource));
    }

    public static void createToast(MutableComponent title, MutableComponent subtitle) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)title, (Component)subtitle));
    }

    public static void povButton(ControlsScreen controlsScreen) {
        int startingY;
        int i = controlsScreen.f_96543_ / 2 - 155;
        int j = i + 160;
        int k = startingY = controlsScreen.f_96544_ / 6 - 12 + 48;
        for (int attempt = 0; attempt < 10; ++attempt) {
            boolean overlaps = false;
            for (Renderable widget : controlsScreen.f_169369_) {
                if (!(widget instanceof AbstractWidget)) continue;
                AbstractWidget existing = (AbstractWidget)widget;
                int existingX = existing.m_252754_();
                int existingY = existing.m_252907_();
                int existingW = existing.m_5711_();
                int existingH = existing.m_93694_();
                if (existingX != j || k >= existingY + existingH || k + 20 <= existingY) continue;
                overlaps = true;
                break;
            }
            if (!overlaps) break;
            k += 24;
        }
        AbstractWidget customButton = VCGlidersClient.autoPerspective.m_231507_(Minecraft.m_91087_().f_91066_, j, k, 150);
        controlsScreen.m_142416_((GuiEventListener)customButton);
        for (Renderable widget : controlsScreen.f_169369_) {
            AbstractWidget existing;
            if (!(widget instanceof AbstractWidget) || !(existing = (AbstractWidget)widget).m_6035_().equals(CommonComponents.f_130655_)) continue;
            int desiredY = k + 24;
            if (existing.m_252907_() >= desiredY) break;
            existing.m_253211_(desiredY);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addPredicate(Item item, ResourceLocation resourceLocation, ClampedItemPropertyFunction clampedItemPropertyFunction) {
        void var2_2;
        void var1_1;
        ClientUtilImpl.addPredicate(item, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    public static void setPlayerPerspective(String pointOfView) {
        if (((Boolean)VCGlidersClient.autoPerspective.m_231551_()).booleanValue() && !pointOfView.isEmpty()) {
            backupPerspective = Minecraft.m_91087_().f_91066_.m_92176_();
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.valueOf((String)pointOfView));
            return;
        }
        if (backupPerspective != null) {
            Minecraft.m_91087_().f_91066_.m_92157_(backupPerspective);
            backupPerspective = null;
        }
    }
}

