/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.predicate;

import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class DefaultConnectionPredicates {
    public static ConnectionPredicate and(ConnectionPredicate ... predicates) {
        return new AndConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate or(ConnectionPredicate ... predicates) {
        return new OrConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate not(ConnectionPredicate predicate) {
        return new NotConnectionPredicate(predicate);
    }

    public static ConnectionPredicate isDirection(ConnectionDirection ... directions) {
        return new IsDirectionConnectionPredicate(directions);
    }

    public static ConnectionPredicate isFaceVisible() {
        return IsFaceVisibleConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate isSameBlock() {
        return IsSameBlockConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate isSameState() {
        return IsSameStateConnectionPredicate.INSTANCE;
    }

    public static ConnectionPredicate matchBlock(Block block) {
        return new MatchBlockConnectionPredicate(block);
    }

    public static ConnectionPredicate matchState(Block block, Pair<Property<?>, ?> ... properties) {
        return new MatchStateConnectionPredicate(block, properties);
    }

    public static ConnectionPredicate matchState(BlockState state) {
        return DefaultConnectionPredicates.matchState(state.m_60734_(), (Pair[])state.m_61147_().stream().map(p -> Pair.of(p, state.m_61143_(p))).toArray(Pair[]::new));
    }

    public static ConnectionPredicate matchBlockInFront(Block block) {
        return new MatchBlockInFrontConnectionPredicate(block);
    }

    public static ConnectionPredicate matchStateInFront(Block block, Pair<Property<?>, ?> ... properties) {
        return new MatchStateInFrontConnectionPredicate(block, properties);
    }

    public static ConnectionPredicate matchStateInFront(BlockState state) {
        return DefaultConnectionPredicates.matchStateInFront(state.m_60734_(), (Pair[])state.m_61147_().stream().map(p -> Pair.of(p, state.m_61143_(p))).toArray(Pair[]::new));
    }
}

