/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class EntityRenderTypeHelper {
    private static final Map<String, Function<ResourceLocation, RenderType>> RENDER_TYPES_BY_NAME;
    private static final Map<String, BiFunction<ResourceLocation, Boolean, RenderType>> VAR_OUTLINE_RENDER_TYPES_BY_NAME;

    public static RenderType getRenderTypeWithTexture(RenderType renderType, ResourceLocation texture) {
        Function<ResourceLocation, RenderType> supplier;
        if (renderType instanceof RenderType.CompositeRenderType && (supplier = VAR_OUTLINE_RENDER_TYPES_BY_NAME.get(renderType.f_110133_)) != null) {
            RenderType.OutlineProperty outlineProperty = ((RenderType.CompositeRenderType)renderType).f_110511_.f_110591_;
            return (RenderType)supplier.apply(texture, outlineProperty == RenderType.OutlineProperty.AFFECTS_OUTLINE);
        }
        supplier = RENDER_TYPES_BY_NAME.get(renderType.f_110133_);
        if (supplier != null) {
            return (RenderType)supplier.apply(texture);
        }
        return null;
    }

    static {
        ImmutableMap.Builder renderTypes = ImmutableMap.builder();
        renderTypes.put((Object)"armor_cutout_no_cull", RenderType::m_110431_);
        renderTypes.put((Object)"entity_solid", RenderType::m_110446_);
        renderTypes.put((Object)"entity_cutout", RenderType::m_110452_);
        renderTypes.put((Object)"item_entity_translucent_cull", RenderType::m_110467_);
        renderTypes.put((Object)"entity_translucent_cull", RenderType::m_110470_);
        renderTypes.put((Object)"entity_smooth_cutout", RenderType::m_110476_);
        renderTypes.put((Object)"entity_decal", RenderType::m_110479_);
        renderTypes.put((Object)"entity_no_outline", RenderType::m_110482_);
        renderTypes.put((Object)"entity_alpha", RenderType::m_173235_);
        renderTypes.put((Object)"eyes", RenderType::m_110488_);
        renderTypes.put((Object)"water_mask", t -> RenderType.m_110478_());
        renderTypes.put((Object)"armor_entity_glint", t -> RenderType.m_110484_());
        RENDER_TYPES_BY_NAME = renderTypes.build();
        ImmutableMap.Builder outlineRenderTypes = ImmutableMap.builder();
        outlineRenderTypes.put((Object)"entity_cutout_no_cull", RenderType::m_110443_);
        outlineRenderTypes.put((Object)"entity_cutout_no_cull_z_offset", RenderType::m_110448_);
        outlineRenderTypes.put((Object)"entity_translucent", RenderType::m_110454_);
        outlineRenderTypes.put((Object)"entity_translucent_emissive", RenderType::m_234335_);
        VAR_OUTLINE_RENDER_TYPES_BY_NAME = outlineRenderTypes.build();
    }
}

