/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.misc.OptimizedMath;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.module.MinimapSession;

public abstract class MinimapElementRendererHandler {
    private final HudMod modMain;
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final MinimapElementRenderLocation location;
    private final int indexLimit;

    protected MinimapElementRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, MinimapElementRenderLocation location, int indexLimit) {
        this.modMain = modMain;
        this.renderers = renderers;
        this.location = location;
        this.indexLimit = indexLimit;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
        Collections.sort(this.renderers);
    }

    public void render(GuiGraphics guiGraphics, Vec3 renderPos, float partialTicks, RenderTarget framebuffer, double backgroundCoordinateScale, ResourceKey<Level> mapDimension) {
        Minecraft mc = Minecraft.m_91087_();
        Entity renderEntity = mc.m_91288_();
        LocalPlayer player = mc.f_91074_;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = session.getMultiTextureRenderTypeRenderers();
        MultiBufferSource.BufferSource vanillaBufferSource = guiGraphics.m_280091_();
        boolean cave = session.getProcessor().isCaveModeDisplayed();
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(this.location, renderEntity, (Player)player, renderPos, cave, partialTicks, framebuffer, backgroundCoordinateScale, mapDimension);
        PoseStack matrixStack = guiGraphics.m_280168_();
        this.beforeRender(guiGraphics, renderInfo, vanillaBufferSource);
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            int elementIndex = 0;
            elementIndex = this.renderForRenderer(renderer, guiGraphics, elementIndex, multiTextureRenderTypeRenderers, indexLimit, renderInfo);
            matrixStack.m_85837_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender(guiGraphics, renderInfo, vanillaBufferSource);
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, GuiGraphics guiGraphics, int elementIndex, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, int indexLimit, MinimapElementRenderInfo renderInfo) {
        MinimapElementRenderLocation location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        MultiBufferSource.BufferSource vanillaBufferSource = guiGraphics.m_280091_();
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.preRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(element, renderer, context, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), renderInfo, guiGraphics, vanillaBufferSource)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        return elementIndex;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, GuiGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource) {
        MinimapElementReader<E, RRC> elementReader = renderer.elementReader;
        double elementX = elementReader.getRenderX(element, context, renderInfo.partialTicks);
        double elementY = elementReader.getRenderY(element, context, renderInfo.partialTicks);
        double elementZ = elementReader.getRenderZ(element, context, renderInfo.partialTicks);
        double elementCoordinateScale = elementReader.getCoordinateScale(element, context, renderInfo);
        double coordinateMultiplier = elementCoordinateScale / renderInfo.backgroundCoordinateScale;
        if (coordinateMultiplier == 1.0) {
            return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo, guiGraphics, vanillaBufferSource);
        }
        if (elementReader.shouldScalePartialCoordinates(element, context, renderInfo)) {
            elementX *= coordinateMultiplier;
            elementZ *= coordinateMultiplier;
        } else {
            int flooredRenderX = OptimizedMath.myFloor(elementX);
            int flooredRenderZ = OptimizedMath.myFloor(elementZ);
            elementX = (double)OptimizedMath.myFloor((double)flooredRenderX * coordinateMultiplier) + (elementX - (double)flooredRenderX);
            elementZ = (double)OptimizedMath.myFloor((double)flooredRenderZ * coordinateMultiplier) + (elementZ - (double)flooredRenderZ);
        }
        return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo, guiGraphics, vanillaBufferSource);
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected int getIndexLimit() {
        return this.indexLimit;
    }

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E var1, double var2, double var4, double var6, RR var8, RRC var9, int var10, double var11, MinimapElementRenderInfo var13, GuiGraphics var14, MultiBufferSource.BufferSource var15);

    protected abstract void beforeRender(GuiGraphics var1, MinimapElementRenderInfo var2, MultiBufferSource.BufferSource var3);

    protected abstract void afterRender(GuiGraphics var1, MinimapElementRenderInfo var2, MultiBufferSource.BufferSource var3);

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

