/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.ForgeRegistries;

public class Selectors {
    private static Map<String, Rarity> rarities = new HashMap<String, Rarity>(){
        {
            this.put("common", Rarity.COMMON);
            this.put("uncommon", Rarity.UNCOMMON);
            this.put("rare", Rarity.RARE);
            this.put("epic", Rarity.EPIC);
        }
    };
    private static Map<String, BiPredicate<Tag, String>> nbtComparators = new HashMap<String, BiPredicate<Tag, String>>(){
        {
            this.put("=", (tag, value) -> tag.m_7916_().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.m_7916_().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).m_7061_() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumericTag) {
                        return ((NumericTag)tag).m_7061_() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static List<SelectorDocumentation> selectorDocumentation() {
        return Arrays.asList(new SelectorDocumentation("Match all", "Specifying just an asterisk (*) will match all items.", "*"), new SelectorDocumentation("Item ID", "Use item ID to match single items.  Must include mod name for modded items.", "minecraft:stick", "iron_ore", "spoiledeggs:spoiled_egg"), new SelectorDocumentation("Tag", "$ followed by tag name to match all items with that tag.", "$forge:stone", "$planks"), new SelectorDocumentation("Mod name", "@ followed by mod identifier to match all items from that mod.", "@spoiledeggs"), new SelectorDocumentation("Rarity", "! followed by item's rarity to match all items with that rarity.  This is ONLY vanilla rarities.", "!uncommon", "!rare", "!epic"), new SelectorDocumentation("Item name color", "# followed by color hex code, to match all items with that exact color item name.", "#23F632"), new SelectorDocumentation("Display name", "% followed by any text.  Will match any item with this text (case-sensitive) in its tooltip display name.", "%Netherite", "%Uncommon"), new SelectorDocumentation("Tooltip text", "^ followed by any text.  Will match any item with this text (case-sensitive) anywhere in the tooltip text (besides the name).", "^Legendary"), new SelectorDocumentation("NBT tag", "& followed by tag name and optional comparator (=, >, <, or !=) and value, in the format <tag><comparator><value> or just <tag>.", "&Damage=0", "&Tier>1", "&map!=128", "&Enchantments"), new SelectorDocumentation("Negation", "~ followed by any selector above.  This selector will be negated, matching every item that does NOT match the selector.", "~minecraft:stick", "~!uncommon", "~@minecraft"), new SelectorDocumentation("Combining selectors", "Any number of selectors can be combined by separating them with a plus sign.", "minecraft:diamond_sword+&Enchantments", "minecraft:stick+~!common+&Damage=0"));
    }

    public static boolean validateSelector(String value) {
        if (value.contains("+")) {
            for (String selector : value.split("\\+")) {
                if (Selectors.validateSelector(selector)) continue;
                return false;
            }
            return true;
        }
        if (value.startsWith("~")) {
            return Selectors.validateSelector(value.substring(1));
        }
        if (value.contentEquals("*")) {
            return true;
        }
        if (value.startsWith("$")) {
            return ResourceLocation.m_135830_((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return TextColor.m_131268_((String)value) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || ResourceLocation.m_135830_((String)value);
    }

    public static boolean itemMatches(ItemStack item, String selector) {
        if (item.m_41619_()) {
            return false;
        }
        if (selector.contains("+")) {
            for (String subSelector : selector.split("\\+")) {
                if (Selectors.itemMatches(item, subSelector)) continue;
                return false;
            }
            return true;
        }
        if (selector.startsWith("~")) {
            return !Selectors.itemMatches(item, selector.substring(1));
        }
        if (selector.contentEquals("*")) {
            return true;
        }
        String itemResourceLocation = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("#")) {
            TextColor entryColor = TextColor.m_131268_((String)selector);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, TextColor.m_131266_((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.m_41791_() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            Optional<TagKey> matchingTag = BuiltInRegistries.f_257033_.m_203613_().filter(tagKey -> tagKey.f_203868_().equals((Object)new ResourceLocation(selector.substring(1)))).findFirst();
            if (matchingTag.isPresent() && item.m_204117_(matchingTag.get())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.m_41611_().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            Minecraft mc = Minecraft.m_91087_();
            List lines = item.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256730_);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((Component)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<Tag, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            return Selectors.findMatchingSubtag((Tag)ItemUtil.getItemNBT(item), tagName, tagValue, valueChecker);
        }
        return false;
    }

    private static boolean findMatchingSubtag(Tag tag, String key, String value, BiPredicate<Tag, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.m_7060_() == 10) {
            CompoundTag compoundTag = (CompoundTag)tag;
            if (compoundTag.m_128441_(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.m_128423_(key), value);
            }
            for (String innerKey : compoundTag.m_128431_()) {
                if (compoundTag.m_128435_(innerKey) != 9 && compoundTag.m_128435_(innerKey) != 10 || !Selectors.findMatchingSubtag(compoundTag.m_128423_(innerKey), key, value, valueChecker)) continue;
                return true;
            }
            return false;
        }
        if (tag.m_7060_() == 9) {
            ListTag listTag = (ListTag)tag;
            for (Tag innerTag : listTag) {
                if (innerTag.m_7060_() != 9 && innerTag.m_7060_() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public record SelectorDocumentation(String name, String description, List<String> examples) {
        public SelectorDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

