/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonItem;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.AutoWorkbenchMenu;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.IEnergyStorage;

public class AutoWorkbenchScreen
extends IEContainerScreen<AutoWorkbenchMenu> {
    private final List<GuiButtonItem> selectionButtons = new ArrayList<GuiButtonItem>();

    public AutoWorkbenchScreen(AutoWorkbenchMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, AutoWorkbenchScreen.makeTextureLocation("auto_workbench"));
        this.f_97727_ = 184;
        this.f_97731_ = 93;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.f_97735_ + 80, this.f_97736_ + 36, (IEnergyStorage)((AutoWorkbenchMenu)this.f_97732_).energyStorage));
    }

    @Override
    public void m_7856_() {
        BlueprintCraftingRecipe[] recipes;
        this.m_169413_();
        this.selectionButtons.clear();
        super.m_7856_();
        Slot s = ((AutoWorkbenchMenu)this.f_97732_).m_38853_(0);
        if (s != null && s.m_6657_() && s.m_7993_().m_41720_() instanceof EngineersBlueprintItem && (recipes = BlueprintCraftingRecipe.findRecipes((Level)Minecraft.m_91087_().f_91073_, ItemNBTHelper.getString(s.m_7993_(), "blueprint"))) != null && recipes.length > 0) {
            int l = recipes.length;
            int xx = this.f_97735_ + 121;
            int yy = this.f_97736_ + (l > 6 ? 59 - (l - 3) / 3 * 18 : (l > 3 ? 59 : 68));
            for (int i = 0; i < l; ++i) {
                if (recipes[i] == null || ((ItemStack)recipes[i].output.get()).m_41619_()) continue;
                GuiButtonItem button = this.makeSelectionButton(xx, yy, i, ((ItemStack)recipes[i].output.get()).m_41777_());
                this.selectionButtons.add(button);
                this.m_142416_((GuiEventListener)button);
            }
        }
    }

    private GuiButtonItem makeSelectionButton(int xx, int yy, int i, ItemStack stack) {
        Button.OnPress handler = btn -> {
            int newId = i == ((AutoWorkbenchMenu)this.f_97732_).selectedRecipe.get() ? -1 : i;
            CompoundTag message = new CompoundTag();
            message.m_128405_("recipe", newId);
            this.sendUpdateToServer(message);
        };
        return new GuiButtonItem(xx + i % 3 * 18, yy + i / 3 * 18, stack, false, handler);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        for (int i = 0; i < this.selectionButtons.size(); ++i) {
            this.selectionButtons.get((int)i).state = i == ((AutoWorkbenchMenu)this.f_97732_).selectedRecipe.get();
        }
        super.drawContainerBackgroundPre(graphics, partialTicks, x, y);
    }
}

