/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FeedthroughBlock
extends ConnectorBlock<FeedthroughBlockEntity> {
    public FeedthroughBlock(BlockBehaviour.Properties props) {
        super(props, IEBlockEntities.FEEDTHROUGH);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.FACING_ALL, BlockStateProperties.f_61362_});
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof FeedthroughBlockEntity && !world.f_46443_ && newState.m_60734_() != state.m_60734_()) {
            FeedthroughBlockEntity feedthrough = (FeedthroughBlockEntity)tile;
            if (!feedthrough.currentlyDisassembling) {
                Direction dir = feedthrough.getFacing();
                BlockPos centerPos = pos.m_5484_(dir, -feedthrough.offset);
                for (int offset : new int[]{-1, 1, 0}) {
                    if (offset == feedthrough.offset) continue;
                    BlockPos posForOffset = centerPos.m_5484_(dir, offset);
                    BlockEntity tileAtOffset = world.m_7702_(posForOffset);
                    if (tileAtOffset instanceof FeedthroughBlockEntity) {
                        ((FeedthroughBlockEntity)tileAtOffset).currentlyDisassembling = true;
                    }
                    if (offset == 0) {
                        world.m_46597_(posForOffset, feedthrough.stateForMiddle);
                        continue;
                    }
                    BlockState connector = (BlockState)WireApi.INFOS.get(feedthrough.reference).connector().m_61124_((Property)IEProperties.FACING_ALL, (Comparable)(offset < 0 ? dir : dir.m_122424_()));
                    ConnectionPoint cpOnFeedthrough = new ConnectionPoint(centerPos, FeedthroughBlockEntity.getIndexForOffset(offset));
                    GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
                    ArrayList removedConnections = new ArrayList();
                    global.removeAllConnectionsAt(cpOnFeedthrough, removedConnections::add);
                    world.m_46597_(posForOffset, connector);
                    ConnectionPoint newEnd = new ConnectionPoint(posForOffset, 0);
                    for (Connection c : removedConnections) {
                        ConnectionPoint otherEnd = c.getOtherEnd(cpOnFeedthrough);
                        global.addConnection(new Connection(c.type, newEnd, otherEnd, global));
                    }
                }
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
    }
}

