/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class ArtifactAttributeModifier {
    private final Attribute attribute;
    private final UUID modifierId;
    private final String modifierName;

    public ArtifactAttributeModifier(Attribute attribute, UUID modifierId, String modifierName) {
        this.attribute = attribute;
        this.modifierId = modifierId;
        this.modifierName = modifierName;
    }

    protected AttributeModifier createModifier() {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount(), this.getOperation());
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    protected UUID getModifierId() {
        return this.modifierId;
    }

    public abstract double getAmount();

    public AttributeModifier.Operation getOperation() {
        return AttributeModifier.Operation.ADDITION;
    }

    protected void onAttributeUpdated(LivingEntity entity) {
    }

    public static ArtifactAttributeModifier create(Attribute attribute, UUID modifierId, String modifierName, final Supplier<Double> amount) {
        return new ArtifactAttributeModifier(attribute, modifierId, modifierName){

            @Override
            public double getAmount() {
                return (Double)amount.get();
            }
        };
    }
}

