/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.hook;

import fabric.me.thosea.badoptimizations.config.Config;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.Nullable;

public final class HookCreator {
    public static final String INVALID_HOOK_MESSAGE = "Mod {} specifies an invalid BadOptimizations caching hook";

    private HookCreator() {
    }

    @Nullable
    public static BooleanSupplier tryCreateHook(String modId, String clazzName) {
        Class<?> clazz;
        if (clazzName == null) {
            return null;
        }
        try {
            clazz = Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            Config.LOGGER.warn(INVALID_HOOK_MESSAGE, (Object)modId);
            Config.LOGGER.warn("No class named \"{}\"", (Object)clazzName);
            return null;
        }
        if (!BooleanSupplier.class.isAssignableFrom(clazz)) {
            Config.LOGGER.warn(INVALID_HOOK_MESSAGE, (Object)modId);
            Config.LOGGER.warn("Class {} does not implement java.util.function.BooleanSupplier", (Object)clazzName);
            return null;
        }
        try {
            return (BooleanSupplier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Config.LOGGER.warn(INVALID_HOOK_MESSAGE, (Object)modId);
            Config.LOGGER.warn("Class {} does not have a public empty default constructor", (Object)clazzName);
            return null;
        }
        catch (Exception e) {
            Config.LOGGER.warn("Failed to create caching hooks for mod {}", (Object)modId);
            Config.LOGGER.warn("", (Throwable)e);
            return null;
        }
    }
}

