/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class RitualPlinthRenderer
implements BlockEntityRenderer<RitualPlinthBlockEntity> {
    public static final RenderTypeToken INCOMPLETE_RITUAL = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/vfx/ritual/incomplete_ritual.png"));
    public static final RenderTypeToken SILHOUETTE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/vfx/ritual/silhouette.png"));

    public RitualPlinthRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RitualPlinthBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack stack = blockEntityIn.inventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            Vec3 offset = blockEntityIn.getCentralItemOffset();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)(level.m_46467_() % 360L) + partialTicks) * 3.0f));
            poseStack.m_85841_(0.45f, 0.45f, 0.45f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
            poseStack.m_85849_();
        }
        MalumRitualType ritualType = blockEntityIn.ritualType;
        MalumRitualTier ritualTier = blockEntityIn.ritualTier;
        if (blockEntityIn.activeDuration > 0.0f && ritualType != null) {
            boolean hasDecor = ritualTier != null && !MalumRitualTier.FADED.equals(ritualTier);
            LodestoneRenderType silhouette = LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(SILHOUETTE);
            LodestoneRenderType icon = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(ritualTier == null ? INCOMPLETE_RITUAL : RenderTypeToken.createCachedToken((ResourceLocation)ritualType.getIcon()));
            LodestoneRenderType decorGlow = hasDecor ? LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((ResourceLocation)ritualTier.getDecorTexture())) : null;
            LodestoneRenderType decorSilhouette = hasDecor ? LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((ResourceLocation)ritualTier.getDecorTexture())) : null;
            MalumSpiritType spirit = ritualType.spirit;
            Vec3 offset = blockEntityIn.getRitualIconOffset(partialTicks);
            float scalar = Math.min(blockEntityIn.activeDuration, 15.0f) / 15.0f;
            float alpha = 0.9f * scalar;
            float scale = 0.25f * (1.0f + scalar);
            VFXBuilders.WorldVFXBuilder worldVFXBuilder = VFXBuilders.createWorld().replaceBufferSource(RenderHandler.LATE_DELAYED_RENDER).setColor(spirit.getPrimaryColor()).setAlpha(alpha);
            VFXBuilders.WorldVFXBuilder backgroundBuilder = VFXBuilders.createWorld().setColor(EthericNitrateEntity.SECOND_SMOKE_COLOR).setAlpha(0.4f * scalar);
            poseStack.m_85836_();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            worldVFXBuilder.setRenderType((RenderType)icon).renderQuad(poseStack, scale);
            if (hasDecor) {
                worldVFXBuilder.setRenderType((RenderType)decorGlow).renderQuad(poseStack, scale * 2.5f);
            }
            float gameTime = (float)level.m_46467_() + partialTicks;
            int time = 160;
            float distance = 0.01f;
            for (int i = 0; i < 8; ++i) {
                boolean odd = i % 2 == 0;
                double angle = (double)((float)i / 8.0f) * (Math.PI * 2);
                double xOffset = (double)distance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                double zOffset = (double)distance * Math.sin(angle);
                poseStack.m_85837_(xOffset, zOffset / 2.0, zOffset);
                worldVFXBuilder.setRenderType((RenderType)icon).setAlpha(alpha * ((float)i / 8.0f)).renderQuad(poseStack, scale);
                backgroundBuilder.setRenderType((RenderType)silhouette).renderQuad(poseStack, scale * (odd ? 0.8f : 1.2f));
                if (hasDecor) {
                    worldVFXBuilder.setRenderType((RenderType)decorGlow).renderQuad(poseStack, scale * 2.5f);
                    backgroundBuilder.setRenderType((RenderType)decorSilhouette).renderQuad(poseStack, scale * (odd ? 2.1f : 2.7f));
                }
                poseStack.m_85837_(-xOffset, -zOffset / 2.0, -zOffset);
                if (i == 4) {
                    worldVFXBuilder.setColor(spirit.getSecondaryColor());
                    alpha *= 0.5f;
                }
                distance += 0.0125f;
            }
            poseStack.m_85849_();
        }
    }
}

