/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;

public class SpiritCatalyzerRenderer
implements BlockEntityRenderer<SpiritCatalyzerCoreBlockEntity> {
    public SpiritCatalyzerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpiritCatalyzerCoreBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Vec3 offset;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack stack = blockEntityIn.inventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            offset = blockEntityIn.getItemOffset();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)(level.m_46467_() % 360L) + partialTicks) * 3.0f));
            poseStack.m_85841_(0.45f, 0.45f, 0.45f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
            poseStack.m_85849_();
        }
        if (!(stack = blockEntityIn.augmentInventory.getStackInSlot(0)).m_41619_()) {
            poseStack.m_85836_();
            offset = blockEntityIn.getAugmentOffset();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)(-level.m_46467_() % 360L) - partialTicks) * 3.0f));
            poseStack.m_85841_(0.45f, 0.45f, 0.45f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
            poseStack.m_85849_();
        }
        if (blockEntityIn.getTarget() != null && blockEntityIn.intensity != null) {
            poseStack.m_85836_();
            BlockPos blockPos = blockEntityIn.m_58899_();
            Vec3 offset2 = blockEntityIn.getItemOffset();
            for (Map.Entry<MalumSpiritType, Integer> entry : blockEntityIn.intensity.entrySet()) {
                if (entry.getValue() <= 0) continue;
                MalumSpiritType spirit = entry.getKey();
                poseStack.m_252880_((float)(-blockPos.m_123341_()), (float)(-blockPos.m_123342_()), (float)(-blockPos.m_123343_()));
                this.renderBeam(blockEntityIn, poseStack, spirit, entry.getValue());
                poseStack.m_85837_((double)blockPos.m_123341_() + offset2.f_82479_, (double)blockPos.m_123342_() + offset2.f_82480_, (double)blockPos.m_123343_() + offset2.f_82481_);
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spirit, (float)entry.getValue().intValue() / 60.0f, partialTicks);
                poseStack.m_85837_(-offset2.f_82479_, -offset2.f_82480_, -offset2.f_82481_);
            }
            poseStack.m_85849_();
        }
    }

    public void renderBeam(SpiritCatalyzerCoreBlockEntity catalyzer, PoseStack poseStack, MalumSpiritType spiritType, int intensity) {
        BlockPos catalyzerPos = catalyzer.m_58899_();
        Vec3 startPos = catalyzer.getItemOffset().m_82520_((double)catalyzerPos.m_123341_(), (double)catalyzerPos.m_123342_(), (double)catalyzerPos.m_123343_());
        Vec3 targetPos = catalyzer.getTarget().getAccelerationPoint();
        Vec3 difference = targetPos.m_82546_(startPos);
        float distance = 0.35f + Easing.SINE_OUT.ease((float)intensity / 60.0f, 0.0f, 0.35f, 1.0f);
        float alpha = (float)intensity / 60.0f;
        Vec3 midPoint = startPos.m_82549_(difference.m_82490_((double)distance));
        LodestoneRenderType renderType = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        SpiritBasedWorldVFXBuilder.create(spiritType).setColor(spiritType.getPrimaryColor()).setRenderType((RenderType)renderType).setAlpha(alpha).renderBeam(poseStack.m_85850_().m_252922_(), startPos, midPoint, 0.4f, b -> b.setColor(spiritType.getSecondaryColor()).setAlpha(0.0f));
    }
}

