/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class VoidConduitRenderer
implements BlockEntityRenderer<VoidConduitBlockEntity> {
    public static final RenderTypeToken VIGNETTE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/block/weeping_well/primordial_soup_vignette.png"));
    public static final RenderTypeToken NOISE_TEXTURE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/vfx/void_noise.png"));

    public VoidConduitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidConduitBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderQuad(blockEntityIn, poseStack, partialTicks);
    }

    public void renderQuad(VoidConduitBlockEntity voidConduit, PoseStack poseStack, float partialTicks) {
        if (voidConduit.lingeringRadiance == 0) {
            float height = 0.375f;
            float width = 1.5f;
            Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.01f, 0.5f);
            builder.replaceBufferSource((MultiBufferSource)RenderHandler.LATE_DELAYED_RENDER.getTarget()).setRenderType((RenderType)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(VIGNETTE)).renderQuad(poseStack, positions, 1.0f);
            long gameTime = voidConduit.m_58904_().m_46467_();
            float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
            float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
            float alpha = 0.05f;
            LodestoneRenderType renderType = RenderTypeRegistry.ADDITIVE_DISTORTED_TEXTURE.applyAndCache(NOISE_TEXTURE);
            builder.replaceBufferSource((MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());
            for (int i = 0; i < 3; ++i) {
                builder.setAlpha(alpha);
                float speed = 1000.0f + 250.0f * (float)i;
                builder.setColor(SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor()).setRenderType((RenderType)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)i, (LodestoneRenderType)renderType), s -> {
                    s.m_173356_("Speed").m_5985_(speed);
                    s.m_173356_("Width").m_5985_(48.0f);
                    s.m_173356_("Height").m_5985_(48.0f);
                    s.m_173356_("UVEncasement").m_142558_(new Vector4f(-10.0f, 20.0f, -10.0f, 20.0f));
                }));
                builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
                builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
                alpha -= 0.0125f;
                uOffset = -uOffset - 0.2f;
                vOffset = -vOffset + 0.4f;
                poseStack.m_252880_(0.0f, 0.05f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                if (i != 0) continue;
                builder.setColor(SpiritTypeRegistry.ELDRITCH_SPIRIT.getPrimaryColor());
            }
            poseStack.m_85849_();
        }
    }
}

