/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block;

import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;

public class MalumBlockEntityInventory
extends LodestoneBlockEntityInventory {
    public MalumBlockEntityInventory(int slotCount, int allowedItemSize, Predicate<ItemStack> inputPredicate, Predicate<ItemStack> outputPredicate) {
        super(slotCount, allowedItemSize, inputPredicate, outputPredicate);
    }

    public MalumBlockEntityInventory(int slotCount, int allowedItemSize, Predicate<ItemStack> inputPredicate) {
        super(slotCount, allowedItemSize, inputPredicate);
    }

    public MalumBlockEntityInventory(int slotCount, int allowedItemSize) {
        super(slotCount, allowedItemSize);
    }

    public void extractItem(Player playerEntity, ItemStack stack, int slot) {
        super.extractItem(playerEntity, stack, slot);
        SoundEvent soundEvent = this.getExtractSound(stack);
        SoundHelper.playSound((Entity)playerEntity, (SoundEvent)soundEvent, (SoundSource)SoundSource.BLOCKS, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)playerEntity.m_217043_(), (float)0.8f, (float)1.2f));
    }

    public ItemStack insertItem(Player playerEntity, ItemStack stack) {
        ItemStack result = super.insertItem(playerEntity, stack);
        if (!result.m_41619_()) {
            SoundEvent soundEvent = this.getInsertSound(result);
            SoundHelper.playSound((Entity)playerEntity, (SoundEvent)soundEvent, (SoundSource)SoundSource.BLOCKS, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)playerEntity.m_217043_(), (float)0.8f, (float)1.2f));
        }
        return result;
    }

    public SoundEvent getExtractSound(ItemStack stack) {
        return stack.m_41720_() instanceof SpiritShardItem ? (SoundEvent)SoundRegistry.PEDESTAL_SPIRIT_PICKUP.get() : (SoundEvent)SoundRegistry.PEDESTAL_ITEM_PICKUP.get();
    }

    public SoundEvent getInsertSound(ItemStack stack) {
        return stack.m_41720_() instanceof SpiritShardItem ? (SoundEvent)SoundRegistry.PEDESTAL_SPIRIT_INSERT.get() : (SoundEvent)SoundRegistry.PEDESTAL_ITEM_INSERT.get();
    }
}

