/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.blight;

import com.sammy.malum.registry.common.block.BlockTagRegistry;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClingingBlightBlock
extends Block {
    protected static final VoxelShape SHAPE_GROUNDED_ROOTS_X = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)6.0, (double)14.0);
    protected static final VoxelShape SHAPE_GROUNDED_ROOTS_Z = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_ROOTED_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_ROOTED_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHAPE_ROOTED_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_ROOTED_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BRACED_SOUTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BRACED_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_HANGING_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_HANGING_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_HANGING_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_HANGING_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_HANGING_ROOTS_X = Block.m_49796_((double)0.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_HANGING_ROOTS_Z = Block.m_49796_((double)2.0, (double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    public static final EnumProperty<BlightType> BLIGHT_TYPE = EnumProperty.m_61587_((String)"blight_type", BlightType.class);

    public ClingingBlightBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.ROOTED_BLIGHT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{BLIGHT_TYPE});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(direction.m_122434_().m_122479_() ? direction.m_122424_() : context.m_8125_()));
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        if (!direction.m_122434_().m_122478_()) {
            state = (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.SOULWOOD_SPIKE));
        } else {
            if (direction.equals((Object)Direction.DOWN)) {
                BlockState aboveState = level.m_8055_(clickedPos.m_7494_());
                if (aboveState.m_61138_(BLIGHT_TYPE) && ((BlightType)((Object)aboveState.m_61143_(BLIGHT_TYPE))).equals((Object)BlightType.HANGING_BLIGHT)) {
                    return (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.HANGING_BLIGHT_CONNECTION));
                }
                if (!(state = (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.HANGING_BLIGHT))).m_60710_((LevelReader)level, clickedPos)) {
                    return (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.HANGING_ROOTS));
                }
            }
            if ((direction.m_122434_().m_122479_() || direction.equals((Object)Direction.UP)) && !(state = (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.ROOTED_BLIGHT))).m_60710_((LevelReader)level, clickedPos)) {
                return (BlockState)state.m_61124_(BLIGHT_TYPE, (Comparable)((Object)BlightType.GROUNDED_ROOTS));
            }
        }
        return state.m_60710_((LevelReader)level, clickedPos) ? state : null;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState state;
        BlightType value = (BlightType)((Object)pState.m_61143_(BLIGHT_TYPE));
        Direction direction = (Direction)pState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (value.equals((Object)BlightType.ROOTED_BLIGHT) || value.equals((Object)BlightType.GROUNDED_ROOTS)) {
            BlockPos below = pPos.m_7495_();
            if (!pLevel.m_8055_(below).m_204336_(BlockTagRegistry.BLIGHTED_BLOCKS)) {
                return false;
            }
            if (!Block.m_49863_((LevelReader)pLevel, (BlockPos)below, (Direction)Direction.UP)) {
                return false;
            }
            if (value.equals((Object)BlightType.ROOTED_BLIGHT) && !Block.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_121945_(direction), (Direction)direction.m_122424_())) {
                return false;
            }
        }
        if (!(!value.equals((Object)BlightType.HANGING_BLIGHT_CONNECTION) || (state = pLevel.m_8055_(pPos.m_7494_())).m_61138_(BLIGHT_TYPE) && ((BlightType)((Object)state.m_61143_(BLIGHT_TYPE))).equals((Object)BlightType.HANGING_BLIGHT))) {
            return false;
        }
        if ((value.equals((Object)BlightType.HANGING_BLIGHT) || value.equals((Object)BlightType.HANGING_ROOTS)) && !Block.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_7494_(), (Direction)Direction.DOWN)) {
            return false;
        }
        if (value.equals((Object)BlightType.GROUNDED_ROOTS) || value.equals((Object)BlightType.HANGING_ROOTS)) {
            return true;
        }
        BlockPos pos = pPos.m_121945_(direction);
        return Block.m_49863_((LevelReader)pLevel, (BlockPos)pos, (Direction)direction);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape[] shapeArray = switch ((BlightType)((Object)pState.m_61143_(BLIGHT_TYPE))) {
            case BlightType.GROUNDED_ROOTS -> new VoxelShape[]{SHAPE_GROUNDED_ROOTS_X, SHAPE_GROUNDED_ROOTS_X, SHAPE_GROUNDED_ROOTS_Z, SHAPE_GROUNDED_ROOTS_Z};
            case BlightType.ROOTED_BLIGHT -> new VoxelShape[]{SHAPE_ROOTED_EAST, SHAPE_ROOTED_WEST, SHAPE_ROOTED_SOUTH, SHAPE_ROOTED_NORTH};
            case BlightType.SOULWOOD_SPIKE, BlightType.HANGING_BLIGHT_CONNECTION -> new VoxelShape[]{SHAPE_BRACED_EAST, SHAPE_BRACED_WEST, SHAPE_BRACED_SOUTH, SHAPE_BRACED_NORTH};
            case BlightType.HANGING_BLIGHT -> new VoxelShape[]{SHAPE_HANGING_EAST, SHAPE_HANGING_WEST, SHAPE_HANGING_SOUTH, SHAPE_HANGING_NORTH};
            case BlightType.HANGING_ROOTS -> new VoxelShape[]{SHAPE_HANGING_ROOTS_X, SHAPE_HANGING_ROOTS_X, SHAPE_HANGING_ROOTS_Z, SHAPE_HANGING_ROOTS_Z};
            default -> throw new IllegalStateException("Unexpected value: " + pState.m_61143_(BLIGHT_TYPE));
        };
        switch ((Direction)pState.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case EAST: {
                return shapeArray[0];
            }
            case WEST: {
                return shapeArray[1];
            }
            case SOUTH: {
                return shapeArray[2];
            }
            case NORTH: {
                return shapeArray[3];
            }
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public static enum BlightType implements StringRepresentable
    {
        GROUNDED_ROOTS,
        ROOTED_BLIGHT,
        SOULWOOD_SPIKE,
        HANGING_BLIGHT_CONNECTION,
        HANGING_BLIGHT,
        HANGING_ROOTS;

        final String name = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.name;
        }
    }
}

