/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.runic_workbench;

import com.sammy.malum.common.block.storage.MalumItemHolderBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.packets.particle.curiosities.blight.BlightTransformItemParticlePacket;
import com.sammy.malum.common.recipe.RunicWorkbenchRecipe;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.BlockHelper;

public class RunicWorkbenchBlockEntity
extends MalumItemHolderBlockEntity {
    public static final Vec3 RUNIC_WORKBENCH_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);

    public RunicWorkbenchBlockEntity(BlockEntityType<? extends RunicWorkbenchBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RunicWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RunicWorkbenchBlockEntity>)((BlockEntityType)BlockEntityRegistry.RUNIC_WORKBENCH.get()), pos, state);
    }

    @Override
    public Vec3 getItemOffset(float partialTicks) {
        if (this.inventory.getStackInSlot(0).m_41720_() instanceof SpiritShardItem) {
            float gameTime = (float)this.f_58857_.m_46467_() + partialTicks;
            return RUNIC_WORKBENCH_ITEM_OFFSET.m_82520_(0.0, (double)((float)Math.sin(gameTime % 360.0f / 20.0f) * 0.05f), 0.0);
        }
        return RUNIC_WORKBENCH_ITEM_OFFSET;
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        ItemStack secondaryInput;
        RunicWorkbenchRecipe recipe;
        ItemStack primaryInput = this.inventory.getStackInSlot(0);
        if (!primaryInput.m_41619_() && (recipe = RunicWorkbenchRecipe.getRecipe(this.f_58857_, primaryInput, secondaryInput = player.m_21120_(hand))) != null) {
            Vec3 itemPos = this.getItemPos();
            if (!this.f_58857_.f_46443_) {
                primaryInput.m_41774_(recipe.primaryInput.count);
                secondaryInput.m_41774_(recipe.secondaryInput.count);
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, recipe.output.m_41777_()));
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.ALTERATION_PLINTH_ALTERS.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.25f);
                Item item = secondaryInput.m_41720_();
                if (item instanceof SpiritShardItem) {
                    SpiritShardItem spiritShardItem = (SpiritShardItem)item;
                    PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.m_58899_())), (Object)new BlightTransformItemParticlePacket(List.of(spiritShardItem.type.identifier), itemPos));
                }
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUse(player, hand);
    }
}

