/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.lodestar.lodestone.helpers.BlockHelper;

public class CrucibleAccelerationData {
    public static final CrucibleAccelerationData DEFAULT = new CrucibleAccelerationData();
    public final List<BlockPos> positions = new ArrayList<BlockPos>();
    public final List<ICrucibleAccelerator> accelerators = new ArrayList<ICrucibleAccelerator>();
    public final TunedValue focusingSpeed;
    public final TunedValue damageChance;
    public final TunedValue bonusYieldChance;
    public final TunedValue fuelUsageRate;
    public final TunedValue chainFocusingChance;
    public final TunedValue damageAbsorptionChance;
    public final TunedValue restorationChance;
    public float globalAttributeModifier;

    public static CrucibleAccelerationData createData(ICatalyzerAccelerationTarget target, int lookupRange, Level level, BlockPos pos) {
        Collection nearbyAccelerators = BlockHelper.getBlockEntities(ICrucibleAccelerator.class, (Level)level, (BlockPos)pos, (int)lookupRange);
        ArrayList<ICrucibleAccelerator> validAccelerators = new ArrayList<ICrucibleAccelerator>();
        HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> typeCount = new HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer>();
        for (ICrucibleAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canStartAccelerating() || accelerator.getTarget() != null && !accelerator.getTarget().equals(target) && (accelerator.getTarget() == null || accelerator.getTarget().canBeAccelerated())) continue;
            ICrucibleAccelerator.CrucibleAcceleratorType acceleratorType = accelerator.getAcceleratorType();
            int max = acceleratorType.maximumEntries;
            int amount = typeCount.getOrDefault(acceleratorType, 0);
            if (amount >= max) continue;
            accelerator.setTarget(target);
            validAccelerators.add(accelerator);
            typeCount.put(acceleratorType, amount + 1);
        }
        CrucibleAccelerationData data = new CrucibleAccelerationData(target, typeCount, validAccelerators);
        data.globalAttributeModifier = target.getAccelerationData() != null ? target.getAccelerationData().globalAttributeModifier : 0.0f;
        return data;
    }

    public CrucibleAccelerationData(ICatalyzerAccelerationTarget target, Map<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> typeCount, Collection<ICrucibleAccelerator> accelerators) {
        List<AbstractAugmentItem> augments = Stream.concat(accelerators.stream().map(ICrucibleAccelerator::getAugmentType), target.getAugmentTypes().stream()).filter(Optional::isPresent).map(Optional::get).toList();
        float acceleratorExtraSpeed = typeCount.entrySet().stream().map(entry -> Float.valueOf(((ICrucibleAccelerator.CrucibleAcceleratorType)entry.getKey()).getAcceleration((Integer)entry.getValue()))).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float acceleratorExtraDamage = typeCount.entrySet().stream().map(entry -> Float.valueOf(((ICrucibleAccelerator.CrucibleAcceleratorType)entry.getKey()).getExtraDamageRollChance((Integer)entry.getValue()))).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float tuningStrength = 1.0f + augments.stream().map(AbstractAugmentItem::getTuningStrengthIncrease).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        CrucibleTuning tuning = new CrucibleTuning(target, tuningStrength);
        this.focusingSpeed = tuning.focusingSpeedMultiplier.createTunedValue(augments, AbstractAugmentItem::getSpeedIncrease, acceleratorExtraSpeed);
        this.damageChance = tuning.damageChanceMultiplier.createTunedValue(augments, AbstractAugmentItem::getInstabilityIncrease, acceleratorExtraDamage);
        this.bonusYieldChance = tuning.bonusYieldChanceMultiplier.createTunedValue(augments, AbstractAugmentItem::getFortuneChance);
        this.fuelUsageRate = tuning.fuelUsageRate.createTunedValue(augments, AbstractAugmentItem::getFuelUsageRateIncrease);
        this.chainFocusingChance = tuning.chainFocusingChanceMultiplier.createTunedValue(augments, AbstractAugmentItem::getChainFocusingChance);
        this.damageAbsorptionChance = tuning.damageAbsorptionChanceMultiplier.createTunedValue(augments, AbstractAugmentItem::getShieldingChance);
        this.restorationChance = tuning.restorationChanceMultiplier.createTunedValue(augments, AbstractAugmentItem::getRestorationChance);
        List<CrucibleTuning.CrucibleAttributeType> validTuningTypes = CrucibleTuning.CrucibleAttributeType.getValidValues(this);
        TunedValue weakestValue = CrucibleAccelerationData.figureOutWeakestValue(target.getAccelerationData(), Stream.of(this.focusingSpeed, this.bonusYieldChance, this.chainFocusingChance, this.damageAbsorptionChance, this.restorationChance).filter(t -> validTuningTypes.contains((Object)t.tuning.attributeType)).collect(Collectors.toList()));
        weakestValue.setMultiplier(augments.stream().map(AbstractAugmentItem::getWeakestAttributeMultiplier).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue());
        accelerators.forEach(this::addAccelerator);
    }

    public CrucibleAccelerationData() {
        this.focusingSpeed = new DefaultedTunedValue(1.0f);
        this.damageChance = new DefaultedTunedValue(0.0f);
        this.bonusYieldChance = new DefaultedTunedValue(0.0f);
        this.fuelUsageRate = new DefaultedTunedValue(1.0f);
        this.chainFocusingChance = new DefaultedTunedValue(0.0f);
        this.damageAbsorptionChance = new DefaultedTunedValue(0.0f);
        this.restorationChance = new DefaultedTunedValue(0.0f);
    }

    private void addAccelerator(ICrucibleAccelerator crucibleAccelerator) {
        this.positions.add(((BlockEntity)crucibleAccelerator).m_58899_());
        this.accelerators.add(crucibleAccelerator);
    }

    public void save(CompoundTag compound) {
        CompoundTag acceleratorTag = new CompoundTag();
        if (!this.positions.isEmpty()) {
            acceleratorTag.m_128405_("amount", this.positions.size());
            for (int i = 0; i < this.positions.size(); ++i) {
                BlockPos position = this.positions.get(i);
                BlockHelper.saveBlockPos((CompoundTag)acceleratorTag, (BlockPos)position, (String)("accelerator_" + i + "_"));
            }
        }
        acceleratorTag.m_128350_("globalAttributeModifier", this.globalAttributeModifier);
        compound.m_128365_("acceleratorData", (Tag)acceleratorTag);
    }

    public static CrucibleAccelerationData load(Level level, ICatalyzerAccelerationTarget target, CompoundTag compound) {
        if (level == null) {
            return DEFAULT;
        }
        HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> typeCount = new HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer>();
        ArrayList<ICrucibleAccelerator> accelerators = new ArrayList<ICrucibleAccelerator>();
        if (compound.m_128441_("acceleratorData")) {
            CompoundTag acceleratorTag = compound.m_128469_("acceleratorData");
            int amount = acceleratorTag.m_128451_("amount");
            for (int i = 0; i < amount; ++i) {
                BlockPos pos = BlockHelper.loadBlockPos((CompoundTag)acceleratorTag, (String)("accelerator_" + i + "_"));
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof ICrucibleAccelerator)) continue;
                ICrucibleAccelerator accelerator = (ICrucibleAccelerator)blockEntity;
                typeCount.compute(accelerator.getAcceleratorType(), (type, count) -> count == null ? 1 : count + 1);
                accelerators.add(accelerator);
                accelerator.setTarget(target);
                BlockHelper.updateState((Level)level, (BlockPos)pos);
            }
            CrucibleAccelerationData data = new CrucibleAccelerationData(target, typeCount, accelerators);
            data.globalAttributeModifier = acceleratorTag.m_128457_("globalAttributeModifier");
            return data;
        }
        return DEFAULT;
    }

    public static TunedValue figureOutWeakestValue(CrucibleAccelerationData data, List<TunedValue> tunedValues) {
        if (tunedValues.size() == 1) {
            return tunedValues.get(0);
        }
        return tunedValues.stream().min((t1, t2) -> {
            float difference1 = t1.tuning.getRelativeValue(data, (TunedValue)t1);
            float difference2 = t2.tuning.getRelativeValue(data, (TunedValue)t2);
            return Float.compare(difference1, difference2);
        }).orElse(null);
    }

    public static class TunedValue {
        public final CrucibleTuning.TuningModifier tuning;
        protected final float value;
        private float multiplier = 0.0f;

        public TunedValue(CrucibleTuning.TuningModifier tuning, float bonus) {
            this.tuning = tuning;
            this.value = (tuning.baseValue + bonus) * (1.0f + tuning.getTuningMultiplier());
        }

        protected void setMultiplier(float multiplier) {
            this.multiplier = multiplier;
        }

        public float getValue(CrucibleAccelerationData accelerationData) {
            float modifier = accelerationData.globalAttributeModifier;
            if (this.tuning.attributeType.equals((Object)CrucibleTuning.CrucibleAttributeType.CHAIN_FOCUSING_CHANCE)) {
                modifier *= -1.0f;
            }
            return this.value * this.tuning.getMultiplierScalar(modifier + this.multiplier);
        }
    }

    public static class DefaultedTunedValue
    extends TunedValue {
        public DefaultedTunedValue(float baseValue) {
            super(CrucibleTuning.TuningModifier.DEFAULT, baseValue);
        }

        @Override
        public float getValue(CrucibleAccelerationData accelerationData) {
            return this.value;
        }
    }
}

