/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleAccelerationData;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public class CrucibleTuning {
    public final ICatalyzerAccelerationTarget target;
    public final float tuningStrength;
    public final TuningModifier focusingSpeedMultiplier;
    public final InverseTuningModifier fuelUsageRate;
    public final InverseTuningModifier damageChanceMultiplier;
    public final TuningModifier bonusYieldChanceMultiplier;
    public final TuningModifier chainFocusingChanceMultiplier;
    public final TuningModifier damageAbsorptionChanceMultiplier;
    public final TuningModifier restorationChanceMultiplier;

    public CrucibleTuning(ICatalyzerAccelerationTarget target, float tuningStrength) {
        this.target = target;
        this.tuningStrength = tuningStrength;
        this.focusingSpeedMultiplier = new TuningModifier(this, CrucibleAttributeType.FOCUSING_SPEED, 1.0f);
        this.fuelUsageRate = new InverseTuningModifier(this, CrucibleAttributeType.FUEL_USAGE_RATE, 1.0f);
        this.damageChanceMultiplier = new InverseTuningModifier(this, CrucibleAttributeType.INSTABILITY);
        this.bonusYieldChanceMultiplier = new TuningModifier(this, CrucibleAttributeType.FORTUNE_CHANCE);
        this.chainFocusingChanceMultiplier = new TuningModifier(this, CrucibleAttributeType.CHAIN_FOCUSING_CHANCE);
        this.damageAbsorptionChanceMultiplier = new TuningModifier(this, CrucibleAttributeType.SHIELDING_CHANCE);
        this.restorationChanceMultiplier = new TuningModifier(this, CrucibleAttributeType.RESTORATION_CHANCE);
    }

    public CrucibleAttributeType getTuningType() {
        return this.target.getTuningType();
    }

    public static class TuningModifier {
        public static TuningModifier DEFAULT = new TuningModifier(CrucibleAttributeType.NONE, AppliedTuningType.NONE, 0.0f, 1.0f);
        public final CrucibleAttributeType attributeType;
        public final AppliedTuningType appliedTuningType;
        public final float baseValue;
        public final float tuningPotency;

        private TuningModifier(CrucibleAttributeType attributeType, AppliedTuningType appliedTuningType, float baseValue, float tuningPotency) {
            this.attributeType = attributeType;
            this.appliedTuningType = appliedTuningType;
            this.baseValue = baseValue;
            this.tuningPotency = tuningPotency;
        }

        public TuningModifier(CrucibleTuning tuning, CrucibleAttributeType attributeType, float baseValue) {
            this(attributeType, tuning.getTuningType().equals((Object)CrucibleAttributeType.NONE) ? AppliedTuningType.NONE : (attributeType.equals((Object)tuning.getTuningType()) ? AppliedTuningType.BUFF : AppliedTuningType.DEBUFF), baseValue, tuning.tuningStrength);
        }

        public TuningModifier(CrucibleTuning tuning, CrucibleAttributeType attributeType) {
            this(tuning, attributeType, 0.0f);
        }

        public CrucibleAccelerationData.TunedValue createTunedValue(List<AbstractAugmentItem> augmentItems, Function<AbstractAugmentItem, Float> mappingFunction) {
            return this.createTunedValue(augmentItems.stream().map(mappingFunction).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue());
        }

        public CrucibleAccelerationData.TunedValue createTunedValue(List<AbstractAugmentItem> augmentItems, Function<AbstractAugmentItem, Float> mappingFunction, float bonus) {
            return this.createTunedValue(bonus + augmentItems.stream().map(mappingFunction).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue());
        }

        public CrucibleAccelerationData.TunedValue createTunedValue(float bonus) {
            return new CrucibleAccelerationData.TunedValue(this, bonus);
        }

        public float getRelativeValue(CrucibleAccelerationData data, CrucibleAccelerationData.TunedValue tunedValue) {
            return tunedValue.getValue(data);
        }

        public float getTuningMultiplier() {
            return this.appliedTuningType.multiplierGetter.apply(this).floatValue() * this.tuningPotency;
        }

        protected float getMultiplierScalar(float attributeMultiplier) {
            return 1.0f + attributeMultiplier;
        }

        protected float getPositiveMultiplier() {
            return 0.2f;
        }

        protected float getNegativeMultiplier() {
            return -0.1f;
        }
    }

    public static enum CrucibleAttributeType {
        NONE,
        FOCUSING_SPEED(d -> d.focusingSpeed),
        FUEL_USAGE_RATE(d -> d.fuelUsageRate),
        INSTABILITY(d -> d.damageChance),
        FORTUNE_CHANCE(d -> d.bonusYieldChance),
        CHAIN_FOCUSING_CHANCE(d -> d.chainFocusingChance),
        SHIELDING_CHANCE(d -> d.damageAbsorptionChance),
        RESTORATION_CHANCE(d -> d.restorationChance);

        public final Function<CrucibleAccelerationData, CrucibleAccelerationData.TunedValue> valueGetter;
        public final Predicate<CrucibleAccelerationData> isValueValid;
        public final Function<CrucibleAccelerationData, String> statDisplayFunction;

        private CrucibleAttributeType() {
            this(null, null, null);
        }

        private CrucibleAttributeType(Function<CrucibleAccelerationData, CrucibleAccelerationData.TunedValue> valueGetter) {
            this(valueGetter, d -> ((CrucibleAccelerationData.TunedValue)valueGetter.apply((CrucibleAccelerationData)d)).getValue((CrucibleAccelerationData)d) > 0.0f, d -> String.format("%.2f", Float.valueOf(((CrucibleAccelerationData.TunedValue)valueGetter.apply((CrucibleAccelerationData)d)).getValue((CrucibleAccelerationData)d))));
        }

        private CrucibleAttributeType(Function<CrucibleAccelerationData, CrucibleAccelerationData.TunedValue> valueGetter, Predicate<CrucibleAccelerationData> isValueValid, Function<CrucibleAccelerationData, String> statDisplayFunction) {
            this.valueGetter = valueGetter;
            this.isValueValid = isValueValid;
            this.statDisplayFunction = statDisplayFunction;
        }

        public static List<CrucibleAttributeType> getValidValues(CrucibleAccelerationData data) {
            ArrayList<CrucibleAttributeType> validValues = new ArrayList<CrucibleAttributeType>();
            for (int i = 1; i < CrucibleAttributeType.values().length; ++i) {
                CrucibleAttributeType type = CrucibleAttributeType.values()[i];
                if (!type.isValueValid.test(data)) continue;
                validValues.add(type);
            }
            return validValues;
        }

        public CrucibleAttributeType next(CrucibleAttributeType current, ICatalyzerAccelerationTarget target) {
            int index;
            List<CrucibleAttributeType> validValues = CrucibleAttributeType.getValidValues(target.getAccelerationData());
            int n = index = current.equals((Object)NONE) ? 0 : validValues.indexOf((Object)current) + 1;
            if (index == validValues.size()) {
                return NONE;
            }
            return validValues.get(index % validValues.size());
        }

        public String translation() {
            return "malum.gui.crucible.attribute." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class InverseTuningModifier
    extends TuningModifier {
        public InverseTuningModifier(CrucibleTuning tuning, CrucibleAttributeType attributeType, float baseValue) {
            super(tuning, attributeType, baseValue);
        }

        public InverseTuningModifier(CrucibleTuning tuning, CrucibleAttributeType attributeType) {
            super(tuning, attributeType);
        }

        @Override
        public float getRelativeValue(CrucibleAccelerationData data, CrucibleAccelerationData.TunedValue tunedValue) {
            return this.baseValue - tunedValue.getValue(data);
        }

        @Override
        protected float getMultiplierScalar(float attributeMultiplier) {
            return 1.0f - attributeMultiplier;
        }

        @Override
        protected float getPositiveMultiplier() {
            return -0.2f;
        }

        @Override
        protected float getNegativeMultiplier() {
            return 0.1f;
        }
    }

    public static enum AppliedTuningType {
        BUFF(TuningModifier::getPositiveMultiplier),
        DEBUFF(TuningModifier::getNegativeMultiplier),
        NONE(Float.valueOf(0.0f));

        public final Function<TuningModifier, Float> multiplierGetter;

        private AppliedTuningType(Function<TuningModifier, Float> multiplierGetter) {
            this.multiplierGetter = multiplierGetter;
        }

        private AppliedTuningType(Float value) {
            this.multiplierGetter = t -> value;
        }
    }
}

