/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritRiteRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemBaseBlockEntity
extends LodestoneBlockEntity {
    public static final StringRepresentable.EnumCodec<TotemRiteState> CODEC = StringRepresentable.m_216439_(TotemRiteState::values);
    public final boolean isSoulwood;
    public TotemRiteState state = TotemRiteState.IDLE;
    public TotemicRiteType activeRite;
    public List<BlockPos> totemPolePositions = new ArrayList<BlockPos>();
    private Direction direction;
    public int timer;
    public TotemicRiteType cachedRadiusRite;
    public int radiusVisibility;

    public TotemBaseBlockEntity(BlockEntityType<? extends TotemBaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isSoulwood = ((TotemBaseBlock)state.m_60734_()).corrupted;
    }

    public TotemBaseBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemBaseBlockEntity>)((BlockEntityType)BlockEntityRegistry.TOTEM_BASE.get()), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128359_("state", this.state.name);
        if (this.activeRite != null) {
            compound.m_128359_("rite", this.activeRite.identifier);
        }
        if (this.direction != null) {
            compound.m_128359_("direction", this.direction.m_122433_());
        }
        compound.m_128405_("height", this.totemPolePositions.size());
        compound.m_128405_("timer", this.timer);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.state = compound.m_128441_("state") ? (TotemRiteState)CODEC.m_216455_(compound.m_128461_("state")) : TotemRiteState.IDLE;
        this.activeRite = SpiritRiteRegistry.getRite(compound.m_128461_("rite"));
        this.direction = Direction.m_122402_((String)compound.m_128461_("direction"));
        this.totemPolePositions.clear();
        for (int i = 1; i <= compound.m_128451_("height"); ++i) {
            this.totemPolePositions.add(this.f_58858_.m_6630_(i));
        }
        this.timer = compound.m_128451_("timer");
        super.m_142466_(compound);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            switch (this.state) {
                case ACTIVE: {
                    ++this.timer;
                    if (this.timer < this.activeRite.getRiteEffect(this.isSoulwood).getRiteEffectTickRate()) break;
                    this.activeRite.executeRite(this);
                    this.timer = 0;
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                    break;
                }
                case ASSEMBLING: {
                    --this.timer;
                    if (this.timer > 0) break;
                    BlockPos polePos = this.f_58858_.m_6630_(this.totemPolePositions.size() + 1);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(polePos);
                    if (blockEntity instanceof TotemPoleBlockEntity) {
                        TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
                        this.timer = 20;
                        this.addTotemPole(pole);
                        break;
                    }
                    TotemicRiteType rite = SpiritRiteRegistry.getRite(this.getSpirits());
                    if (rite == null) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.activeRite = rite;
                    this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.ACTIVE);
                    rite.executeRite(this);
                    if (rite.getRiteEffect((boolean)this.isSoulwood).category.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.setState(TotemRiteState.ACTIVE);
                    this.deactivateOtherRites();
                }
            }
        } else if (this.state.equals((Object)TotemRiteState.IDLE) && this.radiusVisibility > 0) {
            --this.radiusVisibility;
            if (this.radiusVisibility == 0) {
                this.cachedRadiusRite = null;
            }
        } else if (this.state.equals((Object)TotemRiteState.ACTIVE) && this.radiusVisibility < 40) {
            if (this.activeRite != null && this.cachedRadiusRite == null) {
                this.cachedRadiusRite = this.activeRite;
            }
            ++this.radiusVisibility;
        }
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.state.equals((Object)TotemRiteState.ASSEMBLING)) {
            return InteractionResult.FAIL;
        }
        if (this.f_58857_.m_7702_(this.f_58858_.m_7494_()) instanceof TotemPoleBlockEntity) {
            if (!this.f_58857_.f_46443_) {
                if (this.state.equals((Object)TotemRiteState.ACTIVE)) {
                    this.setState(TotemRiteState.IDLE);
                } else {
                    this.setState(TotemRiteState.ASSEMBLING);
                }
                BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onBreak(@Nullable Player player) {
        if (!this.f_58857_.f_46443_) {
            this.setState(TotemRiteState.IDLE);
        }
    }

    public void addTotemPole(TotemPoleBlockEntity pole) {
        Direction direction = (Direction)pole.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (this.totemPolePositions.isEmpty()) {
            this.direction = direction;
        }
        if (pole.isSoulwood == this.isSoulwood && direction.equals((Object)this.direction) && pole.type != null) {
            this.totemPolePositions.add(pole.m_58899_());
            pole.riteStarting(this, this.totemPolePositions.size());
        }
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void deactivateOtherRites() {
        TotemicRiteEffect riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
        int horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
        int verticalRadius = riteEffect.getRiteEffectVerticalRadius();
        Collection deactivatedTotems = BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.f_58857_, (BlockPos)riteEffect.getRiteEffectCenter(this), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius);
        for (TotemBaseBlockEntity deactivatedTotem : deactivatedTotems) {
            if (((Object)((Object)deactivatedTotem)).equals((Object)this) || !deactivatedTotem.isActiveOrAssembling() || deactivatedTotem.activeRite == null || !deactivatedTotem.activeRite.equals(this.activeRite)) continue;
            deactivatedTotem.setState(TotemRiteState.IDLE);
        }
        Collection otherTotems = BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)24);
        for (TotemBaseBlockEntity otherTotem : otherTotems) {
            if (((Object)((Object)otherTotem)).equals((Object)this) || otherTotem.activeRite == null || !otherTotem.activeRite.equals(this.activeRite)) continue;
            riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
            horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
            verticalRadius = riteEffect.getRiteEffectVerticalRadius();
            if (!BlockHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.f_58857_, (BlockPos)riteEffect.getRiteEffectCenter(otherTotem), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius).contains((Object)this)) continue;
            otherTotem.setState(TotemRiteState.IDLE);
        }
    }

    public void setState(TotemRiteState state) {
        if (state.equals((Object)TotemRiteState.ACTIVE)) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_ACTIVATED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (state.equals((Object)TotemRiteState.IDLE)) {
            if (this.isActiveOrAssembling()) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_CANCELLED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.INACTIVE);
            this.totemPolePositions.clear();
            this.activeRite = null;
            this.direction = null;
        }
        this.state = state;
        this.timer = 0;
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState state) {
        for (TotemPoleBlockEntity totemPole : this.getTotemPoles()) {
            totemPole.setState(state);
        }
    }

    public List<TotemPoleBlockEntity> getTotemPoles() {
        ArrayList<TotemPoleBlockEntity> totemPoles = new ArrayList<TotemPoleBlockEntity>();
        for (BlockPos totemPolePosition : this.totemPolePositions) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(totemPolePosition);
            if (!(blockEntity instanceof TotemPoleBlockEntity)) continue;
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)blockEntity;
            totemPoles.add(totemPole);
        }
        return totemPoles;
    }

    public List<MalumSpiritType> getSpirits() {
        return this.getTotemPoles().stream().map(t -> t.type).toList();
    }

    public Direction getDirection() {
        BlockState state;
        if (this.direction == null && (state = this.f_58857_.m_8055_(this.f_58858_.m_7494_())).m_60734_() instanceof TotemPoleBlock) {
            this.direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.direction;
    }

    public boolean isActiveOrAssembling() {
        return !this.state.equals((Object)TotemRiteState.IDLE);
    }

    public static enum TotemRiteState implements StringRepresentable
    {
        IDLE("idle"),
        ASSEMBLING("assembling"),
        ACTIVE("active");

        final String name;

        private TotemRiteState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

