/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class TotemPoleBlock<T extends TotemPoleBlockEntity>
extends LodestoneEntityBlock<T> {
    public static final SpiritTypeProperty SPIRIT_TYPE = SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY;
    public final Supplier<? extends Block> logBlock;
    public final boolean isSoulwood;

    public TotemPoleBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> logBlock, boolean isSoulwood) {
        super(properties.lootFrom(logBlock));
        this.logBlock = logBlock;
        this.isSoulwood = isSoulwood;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)SPIRIT_TYPE, (Comparable)((Object)"sacred")));
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)be;
            return Math.min(SpiritTypeRegistry.getIndexForSpiritType(pole.type) + 1, 15);
        }
        return 0;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.logBlock.get().m_7397_(world, pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, SPIRIT_TYPE});
    }
}

