/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weavers_workbench;

import com.sammy.malum.common.block.curiosities.weavers_workbench.WeaversWorkbenchItemHandler;
import com.sammy.malum.common.container.WeaversWorkbenchContainer;
import com.sammy.malum.common.item.cosmetic.skins.ArmorSkin;
import com.sammy.malum.common.packets.particle.curiosities.blight.BlightTransformItemParticlePacket;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class WeaversWorkbenchBlockEntity
extends LodestoneBlockEntity {
    public final WeaversWorkbenchItemHandler itemHandler = new WeaversWorkbenchItemHandler(2, 1, this);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public WeaversWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.WEAVERS_WORKBENCH.get(), pos, state);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new WeaversWorkbenchContainer(w, p, this), WeaversWorkbenchContainer.component);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)container, buf -> buf.m_130064_(this.m_58899_()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap);
    }

    public void onCraft() {
        if (!this.f_58857_.f_46443_) {
            Vec3 itemPos = this.getItemPos();
            PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.m_58899_())), (Object)new BlightTransformItemParticlePacket(List.of(SpiritTypeRegistry.ARCANE_SPIRIT.identifier), itemPos));
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.ALTERATION_PLINTH_ALTERS.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.25f);
        }
        this.itemHandler.getStackInSlot(0).m_41774_(1);
        this.itemHandler.getStackInSlot(1).m_41774_(1);
    }

    public ItemStack tryCraft() {
        this.itemHandler.isCrafting = true;
        ItemStack output = this.getOutput();
        this.itemHandler.setStackInSlot(2, output);
        this.itemHandler.isCrafting = false;
        return output;
    }

    public ItemStack getOutput() {
        ItemStack target = this.itemHandler.getStackInSlot(0);
        ItemStack weave = this.itemHandler.getStackInSlot(1);
        if (!target.m_41619_() && weave.m_41619_() && target.m_41782_() && target.m_41783_().m_128441_("malum:item_skin")) {
            ItemStack result = target.m_41777_();
            result.m_41783_().m_128473_("malum:item_skin");
            return result;
        }
        if (!target.m_41619_() && !weave.m_41619_()) {
            ItemStack result = target.m_41777_();
            String skinTag = ArmorSkin.getApplicableItemSkinTag(target, weave);
            if (skinTag != null) {
                CompoundTag tag = target.m_41784_();
                CompoundTag modifiedTag = tag.m_6426_();
                modifiedTag.m_128359_("malum:item_skin", skinTag);
                if (tag.equals((Object)modifiedTag)) {
                    return ItemStack.f_41583_;
                }
                result.m_41751_(modifiedTag);
                return result;
            }
        }
        return ItemStack.f_41583_;
    }

    public Vec3 getItemPos() {
        return BlockHelper.fromBlockPos((BlockPos)this.m_58899_()).m_82549_(this.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, (double)1.35f, 0.5);
    }
}

