/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.jar;

import com.sammy.malum.common.item.curiosities.SpiritPouchItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.container.ItemInventory;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class SpiritJarBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType type;
    public int count;
    private long lastClickTime;
    private UUID lastClickUUID;
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> new IItemHandler(){

        public int getSlots() {
            return 2;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0 && SpiritJarBlockEntity.this.type != null) {
                return new ItemStack((ItemLike)SpiritJarBlockEntity.this.type.spiritShard.get(), SpiritJarBlockEntity.this.count);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Item item;
            if (slot == 1 && (item = stack.m_41720_()) instanceof SpiritShardItem) {
                SpiritShardItem spiritItem = (SpiritShardItem)item;
                if (SpiritJarBlockEntity.this.type == null || spiritItem.type == SpiritJarBlockEntity.this.type) {
                    if (!simulate) {
                        if (SpiritJarBlockEntity.this.type == null) {
                            SpiritJarBlockEntity.this.type = spiritItem.type;
                        }
                        SpiritJarBlockEntity.this.count += stack.m_41613_();
                        if (!((SpiritJarBlockEntity)SpiritJarBlockEntity.this).f_58857_.f_46443_) {
                            BlockHelper.updateAndNotifyState((Level)SpiritJarBlockEntity.this.f_58857_, (BlockPos)SpiritJarBlockEntity.this.f_58858_);
                        }
                    }
                    return ItemStack.f_41583_;
                }
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || SpiritJarBlockEntity.this.count <= 0) {
                return ItemStack.f_41583_;
            }
            MalumSpiritType extractedType = SpiritJarBlockEntity.this.type;
            if (extractedType == null) {
                return ItemStack.f_41583_;
            }
            int amountToExtract = Math.min(SpiritJarBlockEntity.this.count, amount);
            if (!simulate) {
                SpiritJarBlockEntity.this.count -= amountToExtract;
                if (SpiritJarBlockEntity.this.count == 0) {
                    SpiritJarBlockEntity.this.type = null;
                }
                if (!((SpiritJarBlockEntity)SpiritJarBlockEntity.this).f_58857_.f_46443_) {
                    BlockHelper.updateAndNotifyState((Level)SpiritJarBlockEntity.this.f_58857_, (BlockPos)SpiritJarBlockEntity.this.f_58858_);
                }
            }
            return new ItemStack((ItemLike)extractedType.spiritShard.get(), amountToExtract);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return Math.min(64, SpiritJarBlockEntity.this.count);
            }
            return 64;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Item item = stack.m_41720_();
            if (!(item instanceof SpiritShardItem)) return false;
            SpiritShardItem spiritItem = (SpiritShardItem)item;
            if (spiritItem.type != SpiritJarBlockEntity.this.type) return false;
            return true;
        }
    });

    public SpiritJarBlockEntity(BlockEntityType<? extends SpiritJarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritJarBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_JAR.get()), pos, state);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.m_58904_() == null) {
            return InteractionResult.PASS;
        }
        int count = this.m_58904_().m_46467_() - this.lastClickTime < 10L && player.m_20148_().equals(this.lastClickUUID) ? this.insertAllSpirits(player) : this.insertHeldItem(player);
        this.lastClickTime = this.m_58904_().m_46467_();
        this.lastClickUUID = player.m_20148_();
        if (count != 0) {
            if (player.m_9236_().f_46443_) {
                this.spawnUseParticles(this.f_58857_, this.f_58858_, this.type);
            } else {
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public int insertHeldItem(Player player) {
        int count = 0;
        ItemStack playerStack = player.m_150109_().m_36056_();
        if (!playerStack.m_41619_()) {
            count = this.insertFromStack(playerStack);
        }
        return count;
    }

    public int insertAllSpirits(Player player) {
        if (this.type == null) {
            return 0;
        }
        int count = 0;
        int n = player.m_150109_().m_6643_();
        for (int i = 0; i < n; ++i) {
            ItemStack subStack = player.m_150109_().m_8020_(i);
            if (subStack.m_41619_()) continue;
            int subCount = this.insertFromStack(subStack);
            if (subCount > 0 && subStack.m_41613_() == 0) {
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
            count += subCount;
        }
        return count;
    }

    public int insertFromStack(ItemStack stack) {
        int inserted = 0;
        if (stack.m_41720_() instanceof SpiritPouchItem) {
            if (this.type != null) {
                ItemInventory inventory = SpiritPouchItem.getInventory(stack);
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack spiritStack = inventory.m_8020_(i);
                    Item item = spiritStack.m_41720_();
                    if (!(item instanceof SpiritShardItem)) continue;
                    SpiritShardItem spiritItem = (SpiritShardItem)item;
                    MalumSpiritType type = spiritItem.type;
                    if (!type.identifier.equals(this.type.identifier)) continue;
                    inventory.m_6836_(i, ItemStack.f_41583_);
                    inserted += spiritStack.m_41613_();
                    this.count += spiritStack.m_41613_();
                }
            }
        } else {
            Item item = stack.m_41720_();
            if (item instanceof SpiritShardItem) {
                SpiritShardItem spiritSplinterItem = (SpiritShardItem)item;
                if (this.type == null || this.type.equals(spiritSplinterItem.type)) {
                    this.type = spiritSplinterItem.type;
                    inserted += stack.m_41613_();
                    this.count += stack.m_41613_();
                    stack.m_41774_(stack.m_41613_());
                }
            }
        }
        return inserted;
    }

    public void onPlace(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.m_142466_(stack.m_41783_());
        }
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.type != null) {
            compound.m_128359_("spirit", this.type.identifier);
        }
        compound.m_128405_("count", this.count);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        this.type = compound.m_128441_("spirit") ? SpiritHarvestHandler.getSpiritType(compound.m_128461_("spirit")) : null;
        this.count = compound.m_128451_("count");
        super.m_142466_(compound);
    }

    public void tick() {
        if (this.f_58857_.f_46443_ && this.type != null) {
            SpiritLightSpecs.rotatingLightSpecs(this.f_58857_, this.getItemPos(), this.type, 0.4f, 3);
        }
    }

    public Vec3 getItemPos() {
        double time = (float)this.f_58857_.m_46467_() * 0.05f % 6.28f;
        double x = (float)this.m_58899_().m_123341_() + 0.5f;
        double y = (float)this.m_58899_().m_123342_() + 0.5f + (float)Math.sin(time) * 0.2f;
        double z = (float)this.m_58899_().m_123343_() + 0.5f;
        return new Vec3(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnUseParticles(Level level, BlockPos pos, MalumSpiritType type) {
        Color color = type.getPrimaryColor();
        WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.15f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.2f).build()).setColorData(ColorParticleData.create((Color)color, (Color)color.darker()).build()).setLifetime(20).setRandomMotion((double)0.02f).setRandomOffset((double)0.1f, (double)0.1f).enableNoClip().repeat(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f) + Math.sin((float)level.m_46467_() / 20.0f) * (double)0.2f, (double)((float)pos.m_123343_() + 0.5f), 10);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }
}

