/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class FloatingItemEntity
extends FloatingEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<String> DATA_SPIRIT = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public ItemStack itemStack = ItemStack.f_41583_;
    protected MalumSpiritType spiritType = SpiritTypeRegistry.ARCANE_SPIRIT;

    public FloatingItemEntity(EntityType<? extends FloatingEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        pCompound.m_128359_("spiritType", this.spiritType.identifier);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(itemstack);
        this.setSpirit(pCompound.m_128461_("spiritType"));
    }

    public void setItem(ItemStack pStack) {
        if (!pStack.m_150930_(this.getDefaultItem()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack);
        }
    }

    public MalumSpiritType getSpiritType() {
        return this.spiritType;
    }

    public void setSpirit(MalumSpiritType spiritType) {
        this.setSpirit(spiritType.identifier);
        this.spiritType = spiritType;
    }

    public void setSpirit(String spiritIdentifier) {
        this.m_20088_().m_135381_(DATA_SPIRIT, (Object)spiritIdentifier);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_SPIRIT, (Object)SpiritTypeRegistry.ARCANE_SPIRIT.identifier);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_ITEM_STACK.equals(pKey)) {
            this.itemStack = (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
        }
        if (DATA_SPIRIT.equals(pKey)) {
            this.spiritType = SpiritTypeRegistry.SPIRITS.get(this.f_19804_.m_135370_(DATA_SPIRIT));
        }
        super.m_7350_(pKey);
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.ARCANE_SPIRIT.get();
    }

    public ItemStack getItem() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }
}

