/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.thrown;

import com.sammy.malum.common.item.food.ConcentratedGluttonyItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ThrownConcentratedGluttony
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.m_135353_(ThrownConcentratedGluttony.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final List<TrailPointBuilder> trails = new ArrayList<TrailPointBuilder>(List.of(TrailPointBuilder.create((int)4), TrailPointBuilder.create((int)8), TrailPointBuilder.create((int)12)));
    public float spinOffset = (float)((double)this.f_19796_.m_188501_() * Math.PI * 2.0);
    public int age;
    public boolean fadingAway;
    public int fadingTimer;

    public ThrownConcentratedGluttony(Level pLevel) {
        super((EntityType)EntityRegistry.THROWN_GLUTTONY.get(), pLevel);
    }

    public ThrownConcentratedGluttony(Level pLevel, LivingEntity pShooter) {
        super((EntityType)EntityRegistry.THROWN_GLUTTONY.get(), pShooter, pLevel);
    }

    public ThrownConcentratedGluttony(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)EntityRegistry.THROWN_GLUTTONY.get(), pX, pY, pZ, pLevel);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_FADING_AWAY, (Object)false);
        super.m_8097_();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.f_19804_.m_135370_(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.m_20256_(this.m_20184_().m_82490_((double)0.02f));
            }
        }
        super.m_7350_(pKey);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.age != 0) {
            compound.m_128405_("age", this.age);
        }
        if (this.fadingAway) {
            compound.m_128379_("fadingAway", true);
            compound.m_128405_("fadingTimer", this.fadingTimer);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.age = compound.m_128451_("age");
        this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)compound.m_128471_("fadingAway"));
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.SPLASH_OF_GLUTTONY.get();
    }

    protected float m_7139_() {
        return this.fadingAway ? 0.0f : 0.05f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                TrailPointBuilder trailPointBuilder = this.trails.get(i);
                float offsetScale = (float)i * 0.1f;
                if (this.fadingAway) {
                    offsetScale *= 1.0f + (float)this.fadingTimer / 4.0f;
                }
                for (int j = 0; j < 2; ++j) {
                    float progress = (float)(j + 1) * 0.5f;
                    Vec3 position = this.m_20318_(progress);
                    float scalar = ((float)i * 2.35f + (float)this.age + progress) / 2.0f;
                    double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                    double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                    trailPointBuilder.addTrailPoint(position.m_82520_(xOffset, 0.0, zOffset));
                }
                trailPointBuilder.tickTrailPoints();
            }
        }
        ++this.age;
        if (this.fadingAway) {
            ++this.fadingTimer;
            if (this.fadingTimer >= 40) {
                this.m_146870_();
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        Entity entity;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.fadingAway) {
            return;
        }
        if (pResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)pResult;
            entity = entityHitResult.m_82443_();
        } else {
            entity = null;
        }
        Entity impactedEntity = entity;
        this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)true);
        this.m_20256_(this.m_20184_().m_82490_((double)0.05f));
        level2.m_46796_(2002, this.m_20183_(), ((MobEffect)MobEffectRegistry.GLUTTONY.get()).m_19484_());
        level2.m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.CONCENTRATED_GLUTTONY_DRINK.get(), SoundSource.PLAYERS, 0.5f, 1.25f + level2.f_46441_.m_188501_() * 0.25f);
        ParticleEffectTypeRegistry.THROWN_GLUTTONY_IMPACT.createPositionedEffect((Level)level2, new PositionEffectData(this.m_20182_()));
        this.applyGluttony(level2, impactedEntity);
        super.m_6532_(pResult);
    }

    private void applyGluttony(ServerLevel level, @Nullable Entity impactedEntity) {
        List targets = level.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(3.0, 2.0, 3.0));
        if (!targets.isEmpty()) {
            Entity owner = this.m_150173_();
            MobEffectInstance gluttony = ConcentratedGluttonyItem.createGluttonyEffect(owner);
            for (LivingEntity target : targets) {
                float durationScalar;
                int newDuration;
                double distance;
                if (!target.m_5801_() || !((distance = this.m_20280_((Entity)target)) < 6.0) || (newDuration = gluttony.m_267696_(arg_0 -> ThrownConcentratedGluttony.lambda$applyGluttony$0(durationScalar = target.equals((Object)impactedEntity) ? 1.0f : (float)(1.0 - Math.sqrt(distance) / 4.0), arg_0))) <= 20) continue;
                MobEffectInstance appliedGluttony = ConcentratedGluttonyItem.createGluttonyEffect(owner, durationScalar);
                target.m_147207_(appliedGluttony, owner);
                ConcentratedGluttonyItem.createGluttonyVFX(target, 0.25f);
            }
        }
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        } else if (this.fadingAway) {
            effectScalar = effectScalar * (float)(40 - this.fadingTimer) / 40.0f;
        }
        return effectScalar;
    }

    private static /* synthetic */ int lambda$applyGluttony$0(float durationScalar, int d) {
        return (int)((double)durationScalar * (double)d + 0.5);
    }
}

