/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment;

import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

public class AbstractAugmentItem
extends Item {
    public final MalumSpiritType spiritType;

    public AbstractAugmentItem(Item.Properties pProperties, MalumSpiritType spiritType) {
        super(pProperties);
        this.spiritType = spiritType;
    }

    public float getSpeedIncrease() {
        return 0.0f;
    }

    public float getFuelUsageRateIncrease() {
        return 0.0f;
    }

    public float getInstabilityIncrease() {
        return 0.0f;
    }

    public float getFortuneChance() {
        return 0.0f;
    }

    public float getChainFocusingChance() {
        return 0.0f;
    }

    public float getShieldingChance() {
        return 0.0f;
    }

    public float getRestorationChance() {
        return 0.0f;
    }

    public float getWeakestAttributeMultiplier() {
        return 0.0f;
    }

    public float getTuningStrengthIncrease() {
        return 0.0f;
    }

    public static Optional<AbstractAugmentItem> getAugmentType(ItemStack stack) {
        Optional<AbstractAugmentItem> optional;
        Item item = stack.m_41720_();
        if (item instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)item;
            optional = Optional.of(augmentItem);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"malum.gui.augment.slot").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)("malum.gui.augment.type." + this.getAugmentTypeTranslator())).m_130940_(ChatFormatting.YELLOW)));
    }

    public static void addAugmentAttributeTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)item;
            List tooltip = event.getToolTip();
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237115_((String)"malum.gui.augment.installed").m_130940_(ChatFormatting.GOLD));
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, "malum.gui.crucible.attribute.tuning_potency", augmentItem.getTuningStrengthIncrease());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, "malum.gui.crucible.attribute.weakest_boost", augmentItem.getWeakestAttributeMultiplier());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.RESTORATION_CHANCE, augmentItem.getRestorationChance());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.SHIELDING_CHANCE, augmentItem.getShieldingChance());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.CHAIN_FOCUSING_CHANCE, augmentItem.getChainFocusingChance());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.FORTUNE_CHANCE, augmentItem.getFortuneChance());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.INSTABILITY, augmentItem.getInstabilityIncrease());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.FUEL_USAGE_RATE, augmentItem.getFuelUsageRateIncrease());
            AbstractAugmentItem.addAugmentStatComponent((List<Component>)tooltip, CrucibleTuning.CrucibleAttributeType.FOCUSING_SPEED, augmentItem.getSpeedIncrease());
        }
    }

    public String getAugmentTypeTranslator() {
        return "augment";
    }

    public static void addAugmentStatComponent(List<Component> tooltip, CrucibleTuning.CrucibleAttributeType attributeType, float value) {
        boolean inverse = attributeType.equals((Object)CrucibleTuning.CrucibleAttributeType.FUEL_USAGE_RATE) || attributeType.equals((Object)CrucibleTuning.CrucibleAttributeType.INSTABILITY);
        AbstractAugmentItem.makeAugmentStatComponent(attributeType, value, inverse).ifPresent(tooltip::add);
    }

    public static void addAugmentStatComponent(List<Component> tooltip, String id, float value) {
        AbstractAugmentItem.makeAugmentStatComponent(id, value, false).ifPresent(tooltip::add);
    }

    public static Optional<Component> makeAugmentStatComponent(CrucibleTuning.CrucibleAttributeType attributeType, float value, boolean inverse) {
        return AbstractAugmentItem.makeAugmentStatComponent(attributeType.translation(), value, inverse);
    }

    public static Optional<Component> makeAugmentStatComponent(String id, float value, boolean inverse) {
        if (value == 0.0f) {
            return Optional.empty();
        }
        boolean isPositive = value > 0.0f;
        String modifierSign = isPositive ? "attribute.modifier.plus.0" : "attribute.modifier.take.0";
        ChatFormatting style = ChatFormatting.BLUE;
        if (inverse && isPositive || !inverse && !isPositive) {
            style = ChatFormatting.RED;
        }
        return Optional.of(Component.m_237110_((String)modifierSign, (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(value)), Component.m_237115_((String)id)}).m_130940_(style));
    }
}

