/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.cosmetic.curios;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.systems.item.IEventResponderItem;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioTokenOfGratitude
extends MalumCurioItem
implements IEventResponderItem {
    public static final List<UUID> GRADITUDE_CERTIFIED = new ArrayList<UUID>();
    public static final List<UUID> TRANS_SCARFS = new ArrayList<UUID>();
    public static final UUID SAMMY = CurioTokenOfGratitude.validateForGratitude("0ca54301-6170-4c44-b3e0-b8afa6b81ed2");
    public static final UUID OWL_PERSON = CurioTokenOfGratitude.validateForGratitude("309b2cf6-caa1-4c9a-912d-7b4be827dc8c");
    public static final UUID SNAKE_SCARF_FELLA = CurioTokenOfGratitude.validateForGratitude("07f1452b-7408-47b3-be2b-e6e08869e891");
    public static final UUID BOBBU = CurioTokenOfGratitude.validateForGratitude("3ab4b4b3-dceb-4ff9-a901-fa6edd746070");
    public static final UUID DELLY = CurioTokenOfGratitude.validateForGratitude("7c3a2f88-f6b8-47ff-971d-73544eb5ae62");
    public static final UUID LOFI = CurioTokenOfGratitude.validateForGratitude("85715c8f-4f71-4ebd-9f3a-96dfd8e8e390");
    public static final UUID CREECHURE = CurioTokenOfGratitude.validateForGratitude("9acb0ed8-a6a3-46bc-a6ff-23c176e5ec3d");
    public static final UUID SALT = CurioTokenOfGratitude.validateForGratitude("3585541f-8289-45a9-b8d7-6729bb1d95da");

    public CurioTokenOfGratitude(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.GILDED);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_20148_().equals(SAMMY) || player.m_20148_().equals(LOFI) || player.m_20148_().equals(CREECHURE) || player.m_20148_().equals(SALT))) {
            int interval;
            int n = interval = player.m_6047_() ? 10 : 4000;
            if (player.m_9236_().m_46467_() % (long)interval == 0L) {
                SoundEvent soundEvent = player.m_217043_().m_188503_(8) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11792_;
                player.m_9236_().m_5594_(player, player.m_20183_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public static void giveItem(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (!playerEntity.m_9236_().f_46443_ && GRADITUDE_CERTIFIED.stream().anyMatch(u -> u.equals(playerEntity.m_20148_())) && CurioHelper.findCosmeticCurio(s -> s.m_41720_().equals(ItemRegistry.TOKEN_OF_GRATITUDE.get()), (LivingEntity)playerEntity).isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)((Item)ItemRegistry.TOKEN_OF_GRATITUDE.get()).m_7968_());
            }
        }
    }

    public static UUID validateForGratitude(String uuid) {
        UUID id = UUID.fromString(uuid);
        GRADITUDE_CERTIFIED.add(id);
        return id;
    }

    public static void addTransScarf(UUID uuid) {
        TRANS_SCARFS.add(uuid);
    }

    static {
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("72155db3-d5e4-47fa-8200-c85bf7f87370"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("26b08ef8-a0e8-4a38-b92c-285a14b27d32"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("d30d8e38-6f93-4d96-968d-dd6ec5596941"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("b502a944-7417-4ac7-9ad8-9bc6ff67af0a"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("89719de3-6445-4445-abe2-509659db930d"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("9380b46b-8de4-4a54-b454-88f33059c9ab"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("3a9d3905-3232-4ee2-8e3f-a57290e4a788"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("d3c951e6-824d-41fc-a73d-2a957c1575b1"));
        CurioTokenOfGratitude.addTransScarf(CurioTokenOfGratitude.validateForGratitude("2b90423d-77d1-44e7-baab-015a8be27a71"));
    }
}

