/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import team.lodestar.lodestone.helpers.RandomHelper;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class AbstractMalumCurioItem
extends Item
implements ICurioItem {
    private final Function<Attribute, UUID> uuids = Util.m_143827_(a -> UUID.randomUUID());
    public final MalumTrinketType type;

    public AbstractMalumCurioItem(Item.Properties properties, MalumTrinketType type) {
        super(properties);
        this.type = type;
    }

    public void addAttributeModifiers(Multimap<Attribute, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
    }

    public final Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.addAttributeModifiers((Multimap<Attribute, AttributeModifier>)map, slotContext, stack);
        return map;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), this.type.sound.get(), SoundSource.PLAYERS, 1.0f, RandomHelper.randomBetween((RandomSource)livingEntity.m_217043_(), (float)0.9f, (float)1.1f));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map list = EnchantmentHelper.m_44831_((ItemStack)book);
        if (list.size() == 1 && list.containsKey(Enchantments.f_44975_)) {
            return true;
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void addAttributeModifier(Multimap<Attribute, AttributeModifier> map, Attribute attribute, Function<UUID, AttributeModifier> attributeModifier) {
        map.put((Object)attribute, (Object)attributeModifier.apply(this.uuids.apply(attribute)));
    }

    public static enum MalumTrinketType {
        CLOTH((Supplier<SoundEvent>)SoundRegistry.CLOTH_TRINKET_EQUIP),
        ORNATE((Supplier<SoundEvent>)SoundRegistry.ORNATE_TRINKET_EQUIP),
        GILDED((Supplier<SoundEvent>)SoundRegistry.GILDED_TRINKET_EQUIP),
        ALCHEMICAL((Supplier<SoundEvent>)SoundRegistry.ALCHEMICAL_TRINKET_EQUIP),
        ROTTEN((Supplier<SoundEvent>)SoundRegistry.ROTTEN_TRINKET_EQUIP),
        METALLIC((Supplier<SoundEvent>)SoundRegistry.METALLIC_TRINKET_EQUIP),
        RUNE((Supplier<SoundEvent>)SoundRegistry.RUNE_TRINKET_EQUIP),
        VOID((Supplier<SoundEvent>)SoundRegistry.VOID_TRINKET_EQUIP);

        final Supplier<SoundEvent> sound;

        private MalumTrinketType(Supplier<SoundEvent> sound) {
            this.sound = sound;
        }
    }
}

