/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.scythe;

import com.sammy.malum.common.enchantment.scythe.AscensionEnchantment;
import com.sammy.malum.common.enchantment.scythe.ReboundEnchantment;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ParticleHelper;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.item.ModCombatItem;

public class MalumScytheItem
extends ModCombatItem
implements IMalumEventResponderItem {
    public MalumScytheItem(Tier tier, float damage, float speed, Item.Properties builderIn) {
        super(tier, damage + 3.0f + tier.m_6631_(), speed - 3.2f, builderIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REBOUND.get()) > 0) {
            ReboundEnchantment.throwScythe(level, player, hand, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (stack.getEnchantmentLevel((Enchantment)EnchantmentRegistry.ASCENSION.get()) > 0) {
            AscensionEnchantment.triggerAscension(level, player, hand, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!event.getSource().m_276093_(DamageTypeRegistry.SCYTHE_MELEE)) {
            return;
        }
        boolean canSweep = MalumScytheItem.canSweep(attacker);
        ParticleHelper.SlashParticleEffectBuilder particle = ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.SCYTHE_SLASH);
        Item item = stack.m_41720_();
        if (item instanceof ISpiritAffiliatedItem) {
            ISpiritAffiliatedItem spiritAffiliatedItem = (ISpiritAffiliatedItem)item;
            particle.setSpiritType(spiritAffiliatedItem);
        }
        if (!canSweep) {
            SoundHelper.playSound((Entity)attacker, (SoundEvent)this.getScytheSound(false), (float)1.0f, (float)0.75f);
            particle.setVertical().spawnForwardSlashingParticle((Entity)attacker);
            return;
        }
        SoundHelper.playSound((Entity)attacker, (SoundEvent)this.getScytheSound(true), (float)1.0f, (float)1.0f);
        particle.mirrorRandomly(attacker.m_217043_()).spawnForwardSlashingParticle((Entity)attacker);
        int sweeping = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)attacker);
        float damage = event.getAmount() * (0.5f + EnchantmentHelper.m_44821_((LivingEntity)attacker));
        float radius = 1.0f + (float)sweeping * 0.25f;
        level.m_45933_((Entity)attacker, target.m_20191_().m_82400_((double)radius)).forEach(e -> {
            LivingEntity livingEntity;
            if (e instanceof LivingEntity && (livingEntity = (LivingEntity)e).m_6084_()) {
                livingEntity.m_6469_(DamageTypeHelper.create((Level)level, DamageTypeRegistry.SCYTHE_SWEEP, (Entity)attacker), damage);
                livingEntity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
        });
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44983_)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public SoundEvent getScytheSound(boolean canSweep) {
        return canSweep ? (SoundEvent)SoundRegistry.SCYTHE_SWEEP.get() : (SoundEvent)SoundRegistry.SCYTHE_CUT.get();
    }

    public static boolean canSweep(LivingEntity attacker) {
        return !CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)ItemRegistry.NECKLACE_OF_THE_NARROW_EDGE.get())) && !CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)ItemRegistry.NECKLACE_OF_THE_HIDDEN_BLADE.get()));
    }
}

