/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.color;

import com.sammy.malum.common.packets.particle.base.PositionBasedParticleEffectPacket;
import java.awt.Color;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ColorBasedParticleEffectPacket
extends PositionBasedParticleEffectPacket {
    protected final Color color;

    public ColorBasedParticleEffectPacket(Color color, double posX, double posY, double posZ) {
        super(posX, posY, posZ);
        this.color = color;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        super.encode(buf);
    }

    public static <T extends ColorBasedParticleEffectPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return provider.getPacket(color, posX, posY, posZ);
    }

    public static interface PacketProvider<T extends ColorBasedParticleEffectPacket> {
        public T getPacket(Color var1, double var2, double var4, double var6);
    }
}

