/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritInfusionRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_infusion";
    public final IngredientWithCount input;
    public final boolean useNbtFromInput;
    public final ItemStack output;
    public final List<IngredientWithCount> extraItems;

    public SpiritInfusionRecipe(ResourceLocation id, IngredientWithCount input, boolean useNbtFromInput, ItemStack output, List<SpiritWithCount> spirits, List<IngredientWithCount> extraItems) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.SPIRIT_INFUSION.get(), spirits);
        this.input = input;
        this.useNbtFromInput = useNbtFromInput;
        this.output = output;
        this.extraItems = extraItems;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.input.matches(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return output.m_41720_().equals(this.output.m_41720_());
    }

    public static SpiritInfusionRecipe getRecipe(Level level, ItemStack stack, List<ItemStack> spirits) {
        return SpiritInfusionRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritInfusionRecipe getRecipe(Level level, Predicate<SpiritInfusionRecipe> predicate) {
        return SpiritInfusionRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.SPIRIT_INFUSION.get(), predicate);
    }

    public static List<SpiritInfusionRecipe> getRecipes(Level level) {
        return SpiritInfusionRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.SPIRIT_INFUSION.get());
    }

    public static class Serializer
    implements RecipeSerializer<SpiritInfusionRecipe> {
        public SpiritInfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputObject = json.getAsJsonObject("input");
            IngredientWithCount input = IngredientWithCount.deserialize((JsonObject)inputObject);
            boolean useNbtFromInput = !json.has("useNbtFromInput") || json.getAsJsonPrimitive("useNbtFromInput").getAsBoolean();
            JsonObject outputObject = json.getAsJsonObject("output");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            JsonArray extraItemsArray = json.getAsJsonArray("extra_items");
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemsArray.size(); ++i) {
                JsonObject extraItemObject = extraItemsArray.get(i).getAsJsonObject();
                extraItems.add(IngredientWithCount.deserialize((JsonObject)extraItemObject));
            }
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritInfusionRecipe(recipeId, input, useNbtFromInput, output, spirits, extraItems);
        }

        @Nullable
        public SpiritInfusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            IngredientWithCount input = IngredientWithCount.read((FriendlyByteBuf)buffer);
            boolean useNbtFromInput = buffer.readBoolean();
            ItemStack output = buffer.m_130267_();
            int extraItemCount = buffer.readInt();
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemCount; ++i) {
                extraItems.add(IngredientWithCount.read((FriendlyByteBuf)buffer));
            }
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.m_130267_()));
            }
            return new SpiritInfusionRecipe(recipeId, input, useNbtFromInput, output, spirits, extraItems);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritInfusionRecipe recipe) {
            recipe.input.write(buffer);
            buffer.writeBoolean(recipe.useNbtFromInput);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.extraItems.size());
            for (IngredientWithCount ingredientWithCount : recipe.extraItems) {
                ingredientWithCount.write(buffer);
            }
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount spiritWithCount : recipe.spirits) {
                buffer.m_130055_(spiritWithCount.getStack());
            }
        }
    }
}

