/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class HiddenRecipeSet<T> {
    private final RecipeType<T> recipeType;
    private final Set<T> hiddenRecipes = new HashSet<T>();

    public static HiddenRecipeSet<?> createSet(RecipeType<?> recipeType) {
        return new HiddenRecipeSet(recipeType);
    }

    public HiddenRecipeSet(RecipeType<T> recipeType) {
        this.recipeType = recipeType;
    }

    public void scanAndHideRecipes(IRecipeManager manager, IFocusFactory focusFactory, Collection<TagKey<Item>> nowHidden) {
        ITagManager itemTags = ForgeRegistries.ITEMS.tags();
        if (itemTags != null) {
            List foci = nowHidden.stream().flatMap(tag -> itemTags.getTag(tag).stream()).distinct().flatMap(item -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                IFocus asIngredient = focusFactory.createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
                IFocus asResult = focusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
                IFocus asCatalyst = focusFactory.createFocus(RecipeIngredientRole.CATALYST, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
                return Stream.of(asIngredient, asResult, asCatalyst);
            }).toList();
            manager.createRecipeLookup(this.recipeType).limitFocus(foci).get().forEach(this.hiddenRecipes::add);
            manager.hideRecipes(this.recipeType, this.hiddenRecipes);
        }
    }

    public void unhidePreviouslyHiddenRecipes(IRecipeManager manager) {
        manager.unhideRecipes(this.recipeType, this.hiddenRecipes);
        this.hiddenRecipes.clear();
    }
}

