/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritRepairRecipeCategory
implements IRecipeCategory<SpiritRepairRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_repair");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritRepairRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_repair_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemRegistry.REPAIR_PYLON.get()));
    }

    public void draw(SpiritRepairRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        if (recipe.spirits.size() > 0) {
            ArcanaCodexHelper.renderItemFrames(guiGraphics.m_280168_(), recipe.spirits.size(), 61, 12, false);
        }
    }

    public RecipeType<SpiritRepairRecipe> getRecipeType() {
        return JEIHandler.SPIRIT_REPAIR;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("malum.jei." + UID.m_135815_()));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritRepairRecipe recipe, IFocusGroup focuses) {
        List repaired = recipe.inputs.stream().map(Item::m_7968_).collect(Collectors.toList());
        List repairIngredient = recipe.repairMaterial.getStacks();
        List damaged = repaired.stream().map(ItemStack::m_41777_).peek(s -> s.m_41721_((int)((float)s.m_41776_() * recipe.durabilityPercentage))).collect(Collectors.toCollection(ArrayList::new));
        JEIHandler.addItemsToJei(builder, RecipeIngredientRole.INPUT, 62, 13, false, recipe.spirits);
        IRecipeSlotBuilder input = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 82, 57).addItemStacks(damaged);
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 57).addItemStacks(repairIngredient);
        IRecipeSlotBuilder output = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStacks(repaired.stream().map(SpiritRepairRecipe::getRepairRecipeOutput).collect(Collectors.toList()));
        builder.createFocusLink(new IIngredientAcceptor[]{input, output});
    }
}

