/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.events;

import com.sammy.malum.common.block.storage.jar.SpiritJarBlock;
import com.sammy.malum.common.capability.MalumItemDataCapability;
import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.capability.MalumPlayerDataCapability;
import com.sammy.malum.common.effect.AscensionEffect;
import com.sammy.malum.common.effect.GluttonyEffect;
import com.sammy.malum.common.effect.aura.CorruptedAerialAura;
import com.sammy.malum.common.effect.aura.InfernalAura;
import com.sammy.malum.common.enchantment.HauntedEnchantment;
import com.sammy.malum.common.enchantment.scythe.AnimatedEnchantment;
import com.sammy.malum.common.entity.nitrate.NitrateExplosion;
import com.sammy.malum.common.item.cosmetic.curios.CurioTokenOfGratitude;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.RuneTwinnedDurationItem;
import com.sammy.malum.common.item.curiosities.curios.runes.miracle.RuneAlimentCleansingItem;
import com.sammy.malum.common.item.curiosities.curios.runes.miracle.RuneFervorItem;
import com.sammy.malum.common.item.curiosities.curios.sets.misc.CurioHarmonyNecklace;
import com.sammy.malum.common.item.curiosities.curios.sets.prospector.CurioProspectorBelt;
import com.sammy.malum.common.item.curiosities.curios.sets.rotten.CurioVoraciousRing;
import com.sammy.malum.common.item.curiosities.curios.sets.weeping.CurioHiddenBladeNecklace;
import com.sammy.malum.common.item.curiosities.curios.sets.weeping.CurioWatcherNecklace;
import com.sammy.malum.compability.tetra.TetraCompat;
import com.sammy.malum.core.handlers.EsotericReapingHandler;
import com.sammy.malum.core.handlers.MalignantConversionHandler;
import com.sammy.malum.core.handlers.MalumAttributeEventHandler;
import com.sammy.malum.core.handlers.ReserveStaffChargeHandler;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.handlers.SoulWardHandler;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.core.listeners.ReapingDataReloadListener;
import com.sammy.malum.core.listeners.RitualRecipeReloadListener;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.registry.common.AttributeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

@Mod.EventBusSubscriber
public class RuntimeEvents {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        MalumPlayerDataCapability.attachPlayerCapability(event);
        MalumLivingEntityDataCapability.attachEntityCapability(event);
        MalumItemDataCapability.attachItemCapability(event);
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        MalumPlayerDataCapability.playerJoin(event);
        CurioTokenOfGratitude.giveItem(event);
        SoulDataHandler.updateAi(event);
        TetraCompat.onEntityJoin(event);
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ArrayList<RegistryObject<Attribute>> attributes = new ArrayList<RegistryObject<Attribute>>(List.of(LodestoneAttributeRegistry.MAGIC_RESISTANCE, LodestoneAttributeRegistry.MAGIC_PROFICIENCY, AttributeRegistry.SCYTHE_PROFICIENCY, AttributeRegistry.SOUL_WARD_RECOVERY_RATE, AttributeRegistry.ARCANE_RESONANCE));
            for (RegistryObject<Attribute> attribute : attributes) {
                AttributeInstance instance = living.m_21051_((Attribute)attribute.get());
                if (instance == null || !(instance.m_22115_() <= 0.01)) continue;
                instance.m_22100_(1.0);
            }
        }
    }

    @SubscribeEvent
    public static void playerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof SpiritJarBlock) {
            SpiritJarBlock jarBlock = (SpiritJarBlock)block;
            Player player = event.getEntity();
            BlockHitResult target = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (target.m_6662_() == HitResult.Type.BLOCK && target.m_82425_().equals((Object)pos) && target.m_82434_().m_122434_() == Direction.Axis.X && player.m_7500_()) {
                event.setCanceled(jarBlock.handleAttack(level, pos, player));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(MobSpawnEvent.PositionCheck event) {
        SoulDataHandler.markAsSpawnerSpawned(event);
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        CorruptedAerialAura.onEntityJump(event);
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        AscensionEffect.onEntityFall(event);
        CorruptedAerialAura.onEntityFall(event);
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingChangeTargetEvent event) {
        SoulDataHandler.preventTargeting(event);
    }

    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        CurioHarmonyNecklace.preventDetection(event);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        SoulDataHandler.livingTick(event);
        MalignantConversionHandler.checkForAttributeChanges(event);
        TouchOfDarknessHandler.entityTick(event);
        CurioWatcherNecklace.entityTick(event);
        CurioHiddenBladeNecklace.entityTick(event);
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        MalumLivingEntityDataCapability.syncEntityCapability(event);
        MalumPlayerDataCapability.syncPlayerCapability(event);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        MalumPlayerDataCapability.playerClone(event);
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        InfernalAura.increaseDigSpeed(event);
        RuneFervorItem.increaseDigSpeed(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ReserveStaffChargeHandler.recoverStaffCharges(event);
        SoulWardHandler.playerTick(event);
    }

    @SubscribeEvent
    public static void registerListeners(AddReloadListenerEvent event) {
        SpiritDataReloadListener.register(event);
        ReapingDataReloadListener.register(event);
        RitualRecipeReloadListener.register(event);
        MalignantConversionReloadListener.register(event);
    }

    @SubscribeEvent
    public static void addItemAttributes(ItemAttributeModifierEvent event) {
        HauntedEnchantment.addMagicDamage(event);
        AnimatedEnchantment.addAttackSpeed(event);
    }

    @SubscribeEvent
    public static void isPotionApplicable(MobEffectEvent.Applicable event) {
        GluttonyEffect.canApplyPotion(event);
    }

    @SubscribeEvent
    public static void onPotionApplied(MobEffectEvent.Added event) {
        RuneTwinnedDurationItem.onPotionApplied(event);
        RuneAlimentCleansingItem.onPotionApplied(event);
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        CurioVoraciousRing.accelerateEating(event);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        MalumAttributeEventHandler.processAttributes(event);
        SoulDataHandler.exposeSoul(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLateHurt(LivingHurtEvent event) {
        SoulWardHandler.livingHurt(event);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        EsotericReapingHandler.onDeath(event);
        SpiritHarvestHandler.spawnSpiritsOnDeath(event);
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        SpiritHarvestHandler.primeItemForShatter(event);
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        SpiritHarvestHandler.shatterItem(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        CurioProspectorBelt.processExplosion(event);
        NitrateExplosion.processExplosion(event);
    }
}

