/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MalignantConversionReloadListener
extends SimpleJsonResourceReloadListener {
    public static Map<ResourceLocation, MalignantConversionData> CONVERSION_DATA = new HashMap<ResourceLocation, MalignantConversionData>();
    private static final Gson GSON = new GsonBuilder().create();

    public MalignantConversionReloadListener() {
        super(GSON, "malignant_conversion_data");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new MalignantConversionReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        CONVERSION_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            ArrayList<String> sourceAttributeNames = new ArrayList<String>();
            if (object.has("source_attribute")) {
                String name = object.getAsJsonPrimitive("source_attribute").getAsString();
                sourceAttributeNames.add(name);
            } else if (object.has("source_attributes")) {
                JsonArray sourceAttributes = object.getAsJsonArray("source_attributes");
                for (JsonElement sourceAttribute : sourceAttributes) {
                    sourceAttributeNames.add(sourceAttribute.getAsString());
                }
            }
            for (String name : sourceAttributeNames) {
                JsonElement sourceAttribute;
                sourceAttribute = new ResourceLocation(name);
                if (!ForgeRegistries.ATTRIBUTES.containsKey((ResourceLocation)sourceAttribute)) continue;
                double consumptionRatio = object.has("ratio") ? object.getAsJsonPrimitive("ratio").getAsDouble() : 1.0;
                boolean ignoreBaseValue = object.has("ignore_base_value") && object.getAsJsonPrimitive("ignore_base_value").getAsBoolean();
                JsonArray targetAttributes = object.getAsJsonArray("target_attributes");
                ArrayList<Pair<Attribute, Double>> attributeList = new ArrayList<Pair<Attribute, Double>>();
                for (JsonElement attribute : targetAttributes) {
                    JsonObject attributeObject = attribute.getAsJsonObject();
                    ResourceLocation attributeName = new ResourceLocation(attributeObject.getAsJsonPrimitive("attribute").getAsString());
                    if (!ForgeRegistries.ATTRIBUTES.containsKey(attributeName)) continue;
                    double ratio = attributeObject.getAsJsonPrimitive("ratio").getAsDouble();
                    attributeList.add((Pair<Attribute, Double>)Pair.of((Object)((Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeName)), (Object)ratio));
                }
                CONVERSION_DATA.put((ResourceLocation)sourceAttribute, new MalignantConversionData((Attribute)ForgeRegistries.ATTRIBUTES.getValue((ResourceLocation)sourceAttribute), consumptionRatio, ignoreBaseValue, attributeList));
            }
        }
    }

    public record MalignantConversionData(Attribute sourceAttribute, double consumptionRatio, boolean ignoreBaseValue, List<Pair<Attribute, Double>> targetAttributes) {
    }
}

