/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import java.awt.Color;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class SpiritVisualMotif {
    protected final float alphaMultiplier;
    protected final Color primaryColor;
    protected final Color secondaryColor;
    protected final float colorCoefficient;
    protected final Easing colorEasing;

    public SpiritVisualMotif(Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing) {
        this(1.0f, primaryColor, secondaryColor, colorCoefficient, colorEasing);
    }

    public SpiritVisualMotif(float alphaMultiplier, Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing) {
        this.alphaMultiplier = alphaMultiplier;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.colorCoefficient = colorCoefficient;
        this.colorEasing = colorEasing;
    }

    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return ColorParticleData.create((Color)this.primaryColor, (Color)this.secondaryColor).setCoefficient(this.colorCoefficient * coefficientMultiplier).setEasing(this.colorEasing);
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public float getAlphaMultiplier() {
        return this.alphaMultiplier;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public float getColorCoefficient() {
        return this.colorCoefficient;
    }

    public Easing getColorEasing() {
        return this.colorEasing;
    }
}

