/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class RunicWorkbenchRecipeBuilder {
    private IngredientWithCount primaryInput;
    private IngredientWithCount secondaryInput;
    private final ItemStack output;

    public RunicWorkbenchRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public RunicWorkbenchRecipeBuilder(ItemLike output, int outputCount) {
        this.output = new ItemStack((ItemLike)output.m_5456_(), outputCount);
    }

    public RunicWorkbenchRecipeBuilder setPrimaryInput(IngredientWithCount primaryInput) {
        this.primaryInput = primaryInput;
        return this;
    }

    public RunicWorkbenchRecipeBuilder setPrimaryInput(ItemLike primaryInput, int primaryInputCount) {
        return this.setPrimaryInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{primaryInput}), primaryInputCount);
    }

    public RunicWorkbenchRecipeBuilder setPrimaryInput(Ingredient primaryInput, int primaryInputCount) {
        return this.setPrimaryInput(new IngredientWithCount(primaryInput, primaryInputCount));
    }

    public RunicWorkbenchRecipeBuilder setSecondaryInput(IngredientWithCount secondaryInput) {
        this.secondaryInput = secondaryInput;
        return this;
    }

    public RunicWorkbenchRecipeBuilder setSecondaryInput(ItemLike secondaryInput, int secondaryInputCount) {
        return this.setSecondaryInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{secondaryInput}), secondaryInputCount);
    }

    public RunicWorkbenchRecipeBuilder setSecondaryInput(Ingredient secondaryInput, int secondaryInputCount) {
        return this.setSecondaryInput(new IngredientWithCount(secondaryInput, secondaryInputCount));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("runeworking/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            JsonObject primaryInputObject = RunicWorkbenchRecipeBuilder.this.primaryInput.serialize();
            JsonObject secondaryInputObject = RunicWorkbenchRecipeBuilder.this.secondaryInput.serialize();
            JsonObject outputObject = new JsonObject();
            outputObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)RunicWorkbenchRecipeBuilder.this.output.m_41720_()).toString());
            if (RunicWorkbenchRecipeBuilder.this.output.m_41613_() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)RunicWorkbenchRecipeBuilder.this.output.m_41613_());
            }
            if (RunicWorkbenchRecipeBuilder.this.output.m_41782_()) {
                outputObject.getAsJsonObject().addProperty("nbt", RunicWorkbenchRecipeBuilder.this.output.m_41783_().toString());
            }
            json.add("primaryInput", (JsonElement)primaryInputObject);
            json.add("secondaryInput", (JsonElement)secondaryInputObject);
            json.add("output", (JsonElement)outputObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.RUNEWORKING_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

