/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SlashParticleEffects {
    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, MalumSpiritType spiritType) {
        if (spiritType == null) {
            return SlashParticleEffects.spawnSlashParticle(level, pos);
        }
        return SlashParticleEffects.spawnSlashParticle(level, pos, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos) {
        return SlashParticleEffects.spawnSlashParticle(level, pos, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TRANSPARENT).setColorData(SlashParticleEffects.createGraySlashColor(level.f_46441_)));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, ColorParticleData colorData) {
        return SlashParticleEffects.spawnSlashParticle(level, pos, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(new WorldParticleOptions(ParticleRegistry.HEAVY_SLASH));
        return SlashParticleEffects.spawnSlashParticle(level, pos, builder);
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, WorldParticleBuilder builder) {
        RandomSource rand = level.m_213780_();
        WorldParticleBuilder worldParticleBuilder = builder.setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)2.0f)).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.9f).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setLifetime(5).enableNoClip();
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder);
    }

    public static ColorParticleData createGraySlashColor(RandomSource random) {
        int brightness = (int)(255.0f * RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.0f));
        Color color = new Color(brightness, brightness, brightness);
        return ColorParticleData.create((Color)color, (Color)color.darker()).setEasing(Easing.SINE_IN_OUT).build();
    }
}

