/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.LodestoneTerrainParticleOptions;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SpiritMoteParticleEffects {
    private static final Consumer<LodestoneWorldParticle> SLOWDOWN = p -> {
        Vec3 speed = p.getParticleSpeed();
        double d0 = (Math.random() + Math.random() + 1.0) * (double)0.15f;
        double d1 = Math.sqrt(speed.f_82479_ * speed.f_82479_ + speed.f_82480_ * speed.f_82480_ + speed.f_82481_ * speed.f_82481_);
        p.m_172260_(speed.f_82479_ / d1 * d0 * (double)0.4f, speed.f_82480_ / d1 * d0 * (double)0.4f + (double)0.1f, speed.f_82481_ / d1 * d0 * (double)0.4f);
    };

    public static void destroy(Level level, BlockPos pPos, BlockState pState, MalumSpiritType spiritType) {
        if (!pState.m_60795_()) {
            VoxelShape voxelshape = pState.m_60808_((BlockGetter)level, pPos);
            WorldParticleBuilder builder = SpiritBasedParticleBuilder.createSpirit((WorldParticleOptions)new LodestoneTerrainParticleOptions(LodestoneParticleRegistry.TERRAIN_PARTICLE, pState, pPos)).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TERRAIN_SHEET).setSpirit(spiritType).setGravityStrength(1.0f).setFrictionStrength(0.98f).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.0625f).build()).addSpawnActor(SLOWDOWN);
            voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double xOffset = Math.min(1.0, maxX - minX);
                double yOffset = Math.min(1.0, maxY - minY);
                double zOffset = Math.min(1.0, maxZ - minZ);
                float xDistance = Math.max(2, Mth.m_14165_((double)(xOffset / 0.25)));
                float yDistance = Math.max(2, Mth.m_14165_((double)(yOffset / 0.25)));
                float zDistance = Math.max(2, Mth.m_14165_((double)(zOffset / 0.25)));
                int x = 0;
                while ((float)x < xDistance) {
                    int y = 0;
                    while ((float)y < yDistance) {
                        int z = 0;
                        while ((float)z < zDistance) {
                            float motionX = ((float)x + 0.5f) / xDistance;
                            float motionY = ((float)y + 0.5f) / yDistance;
                            float motionZ = ((float)z + 0.5f) / zDistance;
                            double posX = (double)pPos.m_123341_() + (double)motionX * xOffset + minX;
                            double posY = (double)pPos.m_123342_() + (double)motionY * yOffset + minY;
                            double posZ = (double)pPos.m_123343_() + (double)motionZ * zOffset + minZ;
                            RandomSource random = level.f_46441_;
                            builder.setMotion((double)(motionX - 0.5f + (random.m_188501_() * 2.0f - 1.0f) * 0.4f), (double)(motionY - 0.5f + (random.m_188501_() * 2.0f - 1.0f) * 0.4f), (double)(motionZ - 0.5f + (random.m_188501_() * 2.0f - 1.0f) * 0.4f)).setLifetime(RandomHelper.randomBetween((RandomSource)level.f_46441_, (int)20, (int)40)).spawn(level, posX, posY, posZ);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            });
        }
    }
}

