/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.api.core;

import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.platform.PlatformReference;
import java.util.List;
import java.util.stream.IntStream;

public interface Container
extends PlatformReference {
    public ItemStack getItem(int var1);

    public void setItem(int var1, ItemStack var2);

    public int getContainerSize();

    default public List<ItemStack> getItems() {
        return IntStream.range(0, this.getContainerSize()).mapToObj(this::getItem).toList();
    }

    default public boolean addItem(ItemStack itemStack) {
        List<ItemStack> items = this.getItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack inContainer = items.get(i);
            if (!inContainer.isEmpty()) continue;
            this.setItem(i, itemStack);
            return true;
        }
        return false;
    }

    default public boolean removeItem(int index) {
        this.setItem(index, ItemStack.empty());
        return true;
    }

    default public boolean contains(ItemStack itemStack) {
        return this.getItems().contains(itemStack);
    }

    default public int indexOf(ItemStack itemStack) {
        return this.getItems().indexOf(itemStack);
    }
}

