/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.clipboard;

import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.math.Vector3i;
import dev.huskuraft.effortless.building.clipboard.BlockData;
import dev.huskuraft.effortless.building.clipboard.SnapshotTransform;
import dev.huskuraft.effortless.building.operation.ItemStackUtils;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record Snapshot(String name, long createdTimestamp, List<BlockData> blockData) {
    public static Snapshot EMPTY = new Snapshot("", 0L, List.of());

    public boolean isEmpty() {
        return this.blockData.isEmpty();
    }

    public List<ItemStack> getItems() {
        return ItemStackUtils.flattenStack(this.blockData().stream().map(BlockData::blockState).filter(Objects::nonNull).map(blockState -> blockState.getItem().getDefaultStack().withCount(blockState.getRequiredItemCount())).collect(Collectors.toList()));
    }

    public int volume() {
        return this.box().volume();
    }

    public Vector3i box() {
        if (this.blockData().isEmpty()) {
            return Vector3i.ZERO;
        }
        return new Vector3i(this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().x()).max().getAsInt() - this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().x()).min().getAsInt() + 1, this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().y()).max().getAsInt() - this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().y()).min().getAsInt() + 1, this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().z()).max().getAsInt() - this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().z()).min().getAsInt() + 1);
    }

    public Vector3d getCenter() {
        if (this.blockData().isEmpty()) {
            return Vector3d.ZERO;
        }
        int maxX = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().x()).max().getAsInt();
        int maxY = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().y()).max().getAsInt();
        int maxZ = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().z()).max().getAsInt();
        int minX = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().x()).min().getAsInt();
        int minY = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().y()).min().getAsInt();
        int minZ = this.blockData().stream().mapToInt(blockSnapshot -> blockSnapshot.blockPosition().z()).min().getAsInt();
        return new Vector3d((float)minX + (float)(maxX - minX) / 2.0f + 0.5f, (float)minY + (float)(maxY - minY) / 2.0f + 0.5f, (float)minZ + (float)(maxZ - minZ) / 2.0f + 0.5f);
    }

    public Snapshot withBlockData(List<BlockData> blockData) {
        return new Snapshot(this.name, this.createdTimestamp, blockData);
    }

    public Snapshot update(SnapshotTransform action) {
        switch (action) {
            case ROTATE_X: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.rotate(RotateContext.CLOCKWISE_X_90)).collect(Collectors.toList()));
            }
            case ROTATE_Y: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.rotate(RotateContext.CLOCKWISE_Y_90)).collect(Collectors.toList()));
            }
            case ROTATE_Z: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.rotate(RotateContext.CLOCKWISE_Z_90)).collect(Collectors.toList()));
            }
            case MIRROR_X: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.mirror(MirrorContext.MIRROR_X)).collect(Collectors.toList()));
            }
            case MIRROR_Y: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.mirror(MirrorContext.MIRROR_Y)).collect(Collectors.toList()));
            }
            case MIRROR_Z: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.mirror(MirrorContext.MIRROR_Z)).collect(Collectors.toList()));
            }
            case INCREASE_X: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(1, 0, 0))).collect(Collectors.toList()));
            }
            case INCREASE_Y: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(0, 1, 0))).collect(Collectors.toList()));
            }
            case INCREASE_Z: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(0, 0, 1))).collect(Collectors.toList()));
            }
            case DECREASE_X: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(-1, 0, 0))).collect(Collectors.toList()));
            }
            case DECREASE_Y: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(0, -1, 0))).collect(Collectors.toList()));
            }
            case DECREASE_Z: {
                return this.withBlockData(this.blockData().stream().map(blockSnapshot -> blockSnapshot.move(MoveContext.relative(0, 0, -1))).collect(Collectors.toList()));
            }
        }
        return this;
    }
}

