/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.operation.batch;

import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.BatchOperation;
import dev.huskuraft.effortless.building.operation.batch.BatchOperationResult;
import dev.huskuraft.effortless.building.pattern.MirrorContext;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.RefactorContext;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupOperation
extends BatchOperation {
    protected final List<Operation> operations;

    public GroupOperation(Context context, List<Operation> operations) {
        super(context);
        this.operations = operations;
    }

    public GroupOperation(Context context, Stream<? extends Operation> operations) {
        super(context);
        this.operations = operations.collect(Collectors.toList());
    }

    @Override
    public BatchOperationResult commit() {
        return new BatchOperationResult(this, this.operations().map(Operation::commit).toList());
    }

    @Override
    public GroupOperation move(MoveContext moveContext) {
        return new GroupOperation(this.context, this.operations().map((? super T o) -> (Operation)o.move(moveContext)));
    }

    @Override
    public GroupOperation mirror(MirrorContext mirrorContext) {
        return new GroupOperation(this.context, this.operations().map((? super T o) -> (Operation)o.mirror(mirrorContext)));
    }

    @Override
    public GroupOperation rotate(RotateContext rotateContext) {
        return new GroupOperation(this.context, this.operations().map((? super T o) -> (Operation)o.rotate(rotateContext)));
    }

    @Override
    public GroupOperation refactor(RefactorContext source) {
        return new GroupOperation(this.context, this.operations().map((? super T o) -> (Operation)o.refactor(source)));
    }

    @Override
    public GroupOperation map(UnaryOperator<Operation> operator) {
        return new GroupOperation(this.context, this.operations().map(operator));
    }

    @Override
    public GroupOperation mapEach(UnaryOperator<Operation> operator) {
        return new GroupOperation(this.context, this.operations().map((? super T op) -> {
            if (op instanceof BatchOperation) {
                BatchOperation op1 = (BatchOperation)op;
                return op1.mapEach(operator);
            }
            return (Operation)operator.apply((Operation)op);
        }));
    }

    @Override
    public GroupOperation flatten() {
        return new GroupOperation(this.context, this.operations().flatMap(op -> {
            Stream<Operation> stream;
            if (op instanceof BatchOperation) {
                BatchOperation op1 = (BatchOperation)op;
                stream = op1.flatten().operations();
            } else {
                stream = Stream.of(op);
            }
            return stream;
        }));
    }

    @Override
    public GroupOperation filter(Predicate<Operation> predicate) {
        return new GroupOperation(this.context, this.operations().filter(predicate));
    }

    @Override
    public Stream<? extends Operation> operations() {
        return this.operations.stream();
    }
}

