/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockEntity;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.BlockState;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.Revolve;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.operation.block.Extras;
import dev.huskuraft.effortless.building.pattern.PositionBounded;

public record RotateContext(Axis axis, Vector3d center, double angle, int radius, int length) implements PositionBounded
{
    public static RotateContext CLOCKWISE_X_90 = new RotateContext(Axis.X, Vector3d.ZERO.add(0.5, 0.5, 0.5), 1.5707963267948966, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static RotateContext CLOCKWISE_Y_90 = new RotateContext(Axis.Y, Vector3d.ZERO.add(0.5, 0.5, 0.5), 1.5707963267948966, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static RotateContext CLOCKWISE_Z_90 = new RotateContext(Axis.Z, Vector3d.ZERO.add(0.5, 0.5, 0.5), 1.5707963267948966, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private static BlockState rotateOriginalBlockState(double startAngleToCenter, BlockState blockState) {
        BlockState newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.rotate(Revolve.CLOCKWISE_180);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.rotate(Revolve.COUNTERCLOCKWISE_90);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.rotate(Revolve.CLOCKWISE_90);
        }
        return newBlockState;
    }

    private static BlockState rotateBlockState(BlockState blockState, double angle, boolean alternate) {
        BlockState newBlockState;
        if ((angle -= Math.PI) < -2.3593360828459344 || angle > 2.3530528975387552) {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.mirror(Axis.X);
            }
        } else if (angle < -0.7885397560510381) {
            newBlockState = blockState.rotate(Revolve.COUNTERCLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.mirror(Axis.Z);
            }
        } else if (angle > 0.7822565707438585) {
            newBlockState = blockState.rotate(Revolve.CLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.mirror(Axis.Z);
            }
        } else {
            newBlockState = blockState.rotate(Revolve.CLOCKWISE_180);
            if (alternate) {
                newBlockState = newBlockState.mirror(Axis.X);
            }
        }
        return newBlockState;
    }

    private static Direction rotateDirection(Direction direction, double angle) {
        Direction newDirection = (angle -= Math.PI) < -2.3593360828459344 || angle > 2.3530528975387552 ? direction : (angle < -0.7885397560510381 ? direction.getClockWise(Axis.Y) : (angle > 0.7822565707438585 ? direction.getClockWise(Axis.Y).getClockWise(Axis.Y).getClockWise(Axis.Y) : direction.getClockWise(Axis.Y).getClockWise(Axis.Y)));
        return newDirection;
    }

    private static BlockInteraction rotateX(BlockInteraction blockInteraction, Vector3d center, double angle) {
        Vector3d rotatedPosition = blockInteraction.getPosition().sub(center).rotX(angle).add(center);
        BlockPosition rotatedBlockPosition = BlockPosition.at(center.add(blockInteraction.getBlockPosition().getCenter().sub(center).rotX(angle)));
        return blockInteraction.withDirection(RotateContext.rotateDirection(blockInteraction.getDirection(), angle)).withPosition(rotatedPosition).withBlockPosition(rotatedBlockPosition);
    }

    private static BlockInteraction rotateY(BlockInteraction blockInteraction, Vector3d center, double angle) {
        Vector3d rotatedPosition = blockInteraction.getPosition().sub(center).rotY(angle).add(center);
        BlockPosition rotatedBlockPosition = BlockPosition.at(center.add(blockInteraction.getBlockPosition().getCenter().sub(center).rotY(angle)));
        return blockInteraction.withDirection(RotateContext.rotateDirection(blockInteraction.getDirection(), angle)).withPosition(rotatedPosition).withBlockPosition(rotatedBlockPosition);
    }

    private static BlockInteraction rotateZ(BlockInteraction blockInteraction, Vector3d center, double angle) {
        Vector3d rotatedPosition = blockInteraction.getPosition().sub(center).rotZ(angle).add(center);
        BlockPosition rotatedBlockPosition = BlockPosition.at(center.add(blockInteraction.getBlockPosition().getCenter().sub(center).rotZ(angle)));
        return blockInteraction.withDirection(RotateContext.rotateDirection(blockInteraction.getDirection(), angle)).withPosition(rotatedPosition).withBlockPosition(rotatedBlockPosition);
    }

    public BlockInteraction rotate(BlockInteraction blockInteraction) {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> RotateContext.rotateX(blockInteraction, this.center, this.angle);
            case Axis.Y -> RotateContext.rotateY(blockInteraction, this.center, this.angle);
            case Axis.Z -> RotateContext.rotateZ(blockInteraction, this.center, this.angle);
        };
    }

    public BlockPosition rotate(BlockPosition blockPosition) {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> BlockPosition.at(this.center.add(blockPosition.getCenter().sub(this.center).rotX(this.angle)));
            case Axis.Y -> BlockPosition.at(this.center.add(blockPosition.getCenter().sub(this.center).rotY(this.angle)));
            case Axis.Z -> BlockPosition.at(this.center.add(blockPosition.getCenter().sub(this.center).rotZ(this.angle)));
        };
    }

    public BlockEntity rotate(BlockEntity blockEntity) {
        return blockEntity;
    }

    public BlockState rotate(BlockState blockState) {
        if (blockState == null) {
            return null;
        }
        return RotateContext.rotateBlockState(blockState, this.angle, false);
    }

    public Extras rotate(Extras extras) {
        return extras;
    }

    @Override
    public boolean isInBounds(Vector3d position) {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (position.withX(0.0).distance(this.center.withX(0.0)) <= (double)this.radius && position.withY(0.0).withZ(0.0).distance(this.center.withY(0.0).withZ(0.0)) <= (double)this.length) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (position.withY(0.0).distance(this.center.withY(0.0)) <= (double)this.radius && position.withX(0.0).withZ(0.0).distance(this.center.withX(0.0).withZ(0.0)) <= (double)this.length) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> position.withZ(0.0).distance(this.center.withZ(0.0)) <= (double)this.radius && position.withX(0.0).withY(0.0).distance(this.center.withX(0.0).withY(0.0)) <= (double)this.length;
        };
    }
}

