/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.raidal;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.math.Range1i;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.DeferredBatchOperation;
import dev.huskuraft.effortless.building.pattern.RotateContext;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public record RadialTransformer(UUID id, Text name, Vector3d position, Axis axis, int slices, int radius, int length) implements Transformer
{
    public static final int DEFAULT_SLICE = 4;
    public static final int DEFAULT_RADIUS = 16;
    public static final int DEFAULT_LENGTH = 128;
    public static final Range1i SLICE_RANGE = new Range1i(2, 2880);
    public static final Range1i RADIUS_RANGE = new Range1i(1, 1024);
    public static final Range1i LENGTH_RANGE = new Range1i(1, 1024);
    public static final RadialTransformer ZERO = new RadialTransformer(Vector3d.ZERO, Axis.Y, 0, 16, 128);
    public static final RadialTransformer DEFAULT = new RadialTransformer(Vector3d.ZERO, Axis.Y, 4, 16, 128);

    public RadialTransformer(Vector3d position, Axis axis, int slice, int radius, int length) {
        this(UUID.randomUUID(), Text.empty(), position, axis, slice, radius, length);
    }

    @Override
    public Operation transform(Operation operation) {
        return new DeferredBatchOperation(operation.getContext(), () -> IntStream.range(1, this.slices + 1).mapToObj(i -> {
            double angle = Math.PI * 2 / (double)this.slices * (double)(i % this.slices);
            return (Operation)operation.rotate(new RotateContext(this.axis, this.position, angle, this.radius, this.length));
        }));
    }

    @Override
    public Text getName() {
        if (!this.name().getString().isEmpty()) {
            return this.name();
        }
        return Text.translate("effortless.transformer.radial.no_name");
    }

    @Override
    public Transformers getType() {
        return Transformers.RADIAL;
    }

    public RadialTransformer withPosition(Vector3d position) {
        return new RadialTransformer(this.id, this.name, position, this.axis, this.slices, this.radius, this.length);
    }

    public RadialTransformer withPositionX(double x) {
        return new RadialTransformer(this.id, this.name, new Vector3d(x, this.position.y(), this.position.z()), this.axis, this.slices, this.radius, this.length);
    }

    public RadialTransformer withPositionY(double y) {
        return new RadialTransformer(this.id, this.name, new Vector3d(this.position.x(), y, this.position.z()), this.axis, this.slices, this.radius, this.length);
    }

    public RadialTransformer withPositionZ(double z) {
        return new RadialTransformer(this.id, this.name, new Vector3d(this.position.x(), this.position.y(), z), this.axis, this.slices, this.radius, this.length);
    }

    public RadialTransformer withAxis(Axis axis) {
        return new RadialTransformer(this.id, this.name, this.position, axis, this.slices, this.radius, this.length);
    }

    public RadialTransformer withSlice(int slice) {
        return new RadialTransformer(this.id, this.name, this.position, this.axis, slice, this.radius, this.length);
    }

    public RadialTransformer withRadius(int radius) {
        return new RadialTransformer(this.id, this.name, this.position, this.axis, this.slices, radius, this.length);
    }

    public RadialTransformer withLength(int length) {
        return new RadialTransformer(this.id, this.name, this.position, this.axis, this.slices, this.radius, length);
    }

    @Override
    public Stream<Text> getSearchableTags() {
        return Stream.of(this.getName(), Text.text(this.position.toString()), Text.text(String.valueOf(this.slices)));
    }

    @Override
    public boolean isValid() {
        return POSITION_BOUND.containsIn(this.position) && SLICE_RANGE.contains(this.slices) && RADIUS_RANGE.contains(this.radius);
    }

    @Override
    public RadialTransformer withName(Text name) {
        return new RadialTransformer(this.id, name, this.position, this.axis, this.slices, this.radius, this.length);
    }

    @Override
    public RadialTransformer withId(UUID id) {
        return new RadialTransformer(id, this.name, this.position, this.axis, this.slices, this.radius, this.length);
    }

    @Override
    public float volumeMultiplier() {
        return this.slices;
    }

    @Override
    public List<Text> getDescriptions() {
        return List.of(Text.text("Position " + this.position.x() + " " + this.position.y() + " " + this.position.z()), Text.text("Slices " + this.slices), Text.text("Radius " + this.radius), Text.text("Length " + this.length));
    }
}

