/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.randomize;

import dev.huskuraft.effortless.building.pattern.randomize.Randomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public interface Producer<T> {
    public static <T> Producer<T> createUnordered(Randomizer<T> randomizer, long seed, boolean consume) {
        return new Unordered<T>(Producer.mapRandomizer(randomizer), seed, consume);
    }

    public static <T> Producer<T> createSequence(Randomizer<T> randomizer, long seed, boolean consume) {
        return new Sequence<T>(Producer.mapRandomizer(randomizer), consume);
    }

    public static <T> Producer<T> createSingle(T item) {
        return new Single<T>(item);
    }

    private static <T> List<T> mapRandomizer(Randomizer<T> randomizer) {
        return randomizer.getChances().stream().flatMap(holder -> IntStream.range(0, holder.chance()).mapToObj(i -> holder.content())).toList();
    }

    public T next();

    public static class Unordered<T>
    extends Random
    implements Producer<T> {
        private final List<T> items;
        private final boolean consume;

        public Unordered(List<T> items, long seed, boolean consume) {
            super(seed);
            this.items = consume ? new ArrayList(items) : items;
            this.consume = consume;
        }

        @Override
        public T next() {
            if (this.items.isEmpty()) {
                return null;
            }
            if (this.consume) {
                return this.items.remove(this.nextInt(this.items.size()));
            }
            return this.items.get(this.nextInt(this.items.size()));
        }
    }

    public static class Sequence<T>
    implements Producer<T> {
        private final List<T> items;
        private final boolean consume;
        private int index = 0;

        public Sequence(List<T> items, boolean consume) {
            this.items = consume ? new ArrayList(items) : items;
            this.consume = consume;
        }

        @Override
        public T next() {
            if (this.items.isEmpty()) {
                return null;
            }
            if (this.consume) {
                return this.items.remove(0);
            }
            return this.items.get(this.index++ % this.items.size());
        }
    }

    public static class Single<T>
    implements Producer<T> {
        private final T item;

        public Single(T item) {
            this.item = item;
        }

        @Override
        public T next() {
            return this.item;
        }
    }
}

