/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure;

import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Circle;
import dev.huskuraft.effortless.building.structure.builder.standard.Cone;
import dev.huskuraft.effortless.building.structure.builder.standard.Cuboid;
import dev.huskuraft.effortless.building.structure.builder.standard.Cylinder;
import dev.huskuraft.effortless.building.structure.builder.standard.DiagonalLine;
import dev.huskuraft.effortless.building.structure.builder.standard.DiagonalWall;
import dev.huskuraft.effortless.building.structure.builder.standard.Disable;
import dev.huskuraft.effortless.building.structure.builder.standard.Floor;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Pyramid;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.SlopeFloor;
import dev.huskuraft.effortless.building.structure.builder.standard.Sphere;
import dev.huskuraft.effortless.building.structure.builder.standard.Wall;
import java.awt.Color;

public enum BuildMode {
    DISABLED("disabled", (Structure)new Disable(), Category.BASIC, new BuildFeatures[0]),
    SINGLE("single", (Structure)new Single(), Category.BASIC, new BuildFeatures[0]),
    LINE("line", (Structure)new Line(), Category.SQUARE, BuildFeatures.LINE_DIRECTION),
    WALL("wall", (Structure)new Wall(), Category.SQUARE, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_LENGTH),
    FLOOR("floor", (Structure)new Floor(), Category.SQUARE, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_LENGTH),
    CUBOID("cuboid", (Structure)new Cuboid(), Category.SQUARE, BuildFeatures.CUBE_FILLING, BuildFeatures.PLANE_FACING, BuildFeatures.PLANE_LENGTH),
    DIAGONAL_LINE("diagonal_line", (Structure)new DiagonalLine(), Category.DIAGONAL, new BuildFeatures[0]),
    DIAGONAL_WALL("diagonal_wall", (Structure)new DiagonalWall(), Category.DIAGONAL, BuildFeatures.PLANE_LENGTH),
    SLOPE_FLOOR("slope_floor", (Structure)new SlopeFloor(), Category.DIAGONAL, BuildFeatures.RAISED_EDGE, BuildFeatures.PLANE_LENGTH),
    CIRCLE("circle", (Structure)new Circle(), Category.CIRCULAR, BuildFeatures.CIRCLE_START, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_FACING, BuildFeatures.PLANE_LENGTH),
    CYLINDER("cylinder", (Structure)new Cylinder(), Category.CIRCULAR, BuildFeatures.CIRCLE_START, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_FACING, BuildFeatures.PLANE_LENGTH),
    SPHERE("sphere", (Structure)new Sphere(), Category.CIRCULAR, BuildFeatures.CIRCLE_START, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_FACING, BuildFeatures.PLANE_LENGTH),
    PYRAMID("pyramid", (Structure)new Pyramid(), Category.ROOF, BuildFeatures.PLANE_FILLING, BuildFeatures.PLANE_LENGTH),
    CONE("cone", (Structure)new Cone(), Category.ROOF, BuildFeatures.CIRCLE_START);

    private final Structure defaultStructure;
    private final Category category;
    private final BuildFeatures[] features;
    private final String name;
    private final boolean enabled;

    private BuildMode(String name, Structure instance, Category category, BuildFeatures ... features) {
        this.name = name;
        this.defaultStructure = instance;
        this.category = category;
        this.features = features;
        this.enabled = true;
    }

    private BuildMode(String name, Structure defaultStructure, Category category, boolean enabled, BuildFeatures ... features) {
        this.name = name;
        this.defaultStructure = defaultStructure;
        this.category = category;
        this.features = features;
        this.enabled = enabled;
    }

    public Structure getDefaultStructure() {
        return this.defaultStructure;
    }

    public Color getTintColor() {
        return this.category.getColor();
    }

    public BuildFeatures[] getSupportedFeatures() {
        return this.features;
    }

    public String getName() {
        return this.name;
    }

    public Text getDisplayName() {
        if (this.isDisabled()) {
            return Text.translate("effortless.mode.%s".formatted(this.name)).withStyle(ChatFormatting.GRAY);
        }
        return Text.translate("effortless.mode.%s".formatted(this.name));
    }

    public ResourceLocation getIcon() {
        return ResourceLocation.of("effortless", "textures/mode/%s.png".formatted(this.name));
    }

    public boolean isDisabled() {
        return this == DISABLED;
    }

    public boolean isEnabled() {
        return this != DISABLED;
    }

    public BuildMode next() {
        return this.next(false);
    }

    public BuildMode previous() {
        return this.next(true);
    }

    private BuildMode next(boolean reverse) {
        return BuildMode.values()[(this.ordinal() + (reverse ? -1 : 1) + BuildMode.values().length) % BuildMode.values().length];
    }

    public static enum Category {
        BASIC(new Color(0.0f, 0.5f, 1.0f, 0.5f)),
        SQUARE(new Color(1.0f, 0.54f, 0.24f, 0.5f)),
        DIAGONAL(new Color(0.56f, 0.28f, 0.87f, 0.5f)),
        CIRCULAR(new Color(0.29f, 0.76f, 0.3f, 0.5f)),
        ROOF(new Color(0.83f, 0.87f, 0.23f, 0.5f));

        private final Color color;

        private Category(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

