/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.math.BoundingBox3d;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.Outline;
import dev.huskuraft.effortless.renderer.outliner.OutlineRenderLayers;
import java.awt.Color;

public class BlockBoundingBoxOutline
extends Outline {
    protected BoundingBox3d bb;

    public BlockBoundingBoxOutline(BoundingBox3d bb) {
        this.setBounds(bb);
    }

    @Override
    public void render(Renderer renderer, float deltaTick) {
        this.renderBB(renderer, this.bb);
    }

    public void renderBB(Renderer renderer, BoundingBox3d bb) {
        Vector3d projectedView = renderer.getCamera().position();
        boolean noCull = bb.contains(projectedView);
        bb = bb.inflate(noCull ? -0.0078125 : 0.0078125);
        noCull |= this.params.disableCull;
        Vector3d xyz = new Vector3d(bb.minX(), bb.minY(), bb.minZ());
        Vector3d Xyz = new Vector3d(bb.maxX(), bb.minY(), bb.minZ());
        Vector3d xYz = new Vector3d(bb.minX(), bb.maxY(), bb.minZ());
        Vector3d XYz = new Vector3d(bb.maxX(), bb.maxY(), bb.minZ());
        Vector3d xyZ = new Vector3d(bb.minX(), bb.minY(), bb.maxZ());
        Vector3d XyZ = new Vector3d(bb.maxX(), bb.minY(), bb.maxZ());
        Vector3d xYZ = new Vector3d(bb.minX(), bb.maxY(), bb.maxZ());
        Vector3d XYZ = new Vector3d(bb.maxX(), bb.maxY(), bb.maxZ());
        Vector3d start = xyz;
        this.renderAACuboidLine(renderer, start, Xyz);
        this.renderAACuboidLine(renderer, start, xYz);
        this.renderAACuboidLine(renderer, start, xyZ);
        start = XyZ;
        this.renderAACuboidLine(renderer, start, xyZ);
        this.renderAACuboidLine(renderer, start, XYZ);
        this.renderAACuboidLine(renderer, start, Xyz);
        start = XYz;
        this.renderAACuboidLine(renderer, start, xYz);
        this.renderAACuboidLine(renderer, start, Xyz);
        this.renderAACuboidLine(renderer, start, XYZ);
        start = xYZ;
        this.renderAACuboidLine(renderer, start, XYZ);
        this.renderAACuboidLine(renderer, start, xyZ);
        this.renderAACuboidLine(renderer, start, xYz);
        this.renderFace(renderer, Direction.NORTH, xYz, XYz, Xyz, xyz, noCull);
        this.renderFace(renderer, Direction.SOUTH, XYZ, xYZ, xyZ, XyZ, noCull);
        this.renderFace(renderer, Direction.EAST, XYz, XYZ, XyZ, Xyz, noCull);
        this.renderFace(renderer, Direction.WEST, xYZ, xYz, xyz, xyZ, noCull);
        this.renderFace(renderer, Direction.UP, xYZ, XYZ, XYz, xYz, noCull);
        this.renderFace(renderer, Direction.DOWN, xyz, Xyz, XyZ, xyZ, noCull);
    }

    protected void renderFace(Renderer renderer, Direction direction, Vector3d p1, Vector3d p2, Vector3d p3, Vector3d p4, boolean noCull) {
        if (!this.params.faceTexture.isPresent()) {
            return;
        }
        ResourceLocation faceTexture = this.params.faceTexture.get();
        float alphaBefore = this.params.alpha;
        this.params.alpha = direction == this.params.getHighlightedFace() && this.params.highlightedFaceTexture.isPresent() ? 1.0f : 0.5f;
        RenderLayer renderLayer = OutlineRenderLayers.outlineTranslucent(faceTexture, !noCull);
        Axis axis = direction.getAxis();
        Vector3d uDiff = p2.sub(p1);
        Vector3d vDiff = p4.sub(p1);
        float maxU = (float)MathUtils.abs(axis == Axis.X ? uDiff.z() : uDiff.x());
        float maxV = (float)MathUtils.abs(axis == Axis.Y ? vDiff.z() : vDiff.y());
        renderer.renderQuadUV(renderLayer, p1, p2, p3, p4, 0.0f, 0.0f, maxU, maxV, this.getParams().getLightMap(), new Color(0, 0, 0, 200).getRGB(), Direction.UP);
        this.params.alpha = alphaBefore;
    }

    public void setBounds(BoundingBox3d bb) {
        this.bb = bb;
    }
}

