/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.outliner;

import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.api.renderer.RenderLayer;
import dev.huskuraft.effortless.api.renderer.RenderUtils;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.renderer.outliner.OutlineRenderLayers;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class Outline {
    protected OutlineParams params = new OutlineParams();

    protected Outline() {
    }

    public abstract void render(Renderer var1, float var2);

    public void tick() {
    }

    public OutlineParams getParams() {
        return this.params;
    }

    public void renderCuboidLine(Renderer renderer, Vector3d start, Vector3d end) {
        Vector3d diff = end.sub(start);
        float hDistance = (float)diff.mul(1.0, 0.0, 1.0).length();
        renderer.pushPose();
        renderer.translate(start);
        this.renderAACuboidLine(renderer, Vector3d.ZERO, new Vector3d(0.0, 0.0, diff.length()));
        renderer.popPose();
    }

    public void renderAACuboidLine(Renderer renderer, Vector3d start, Vector3d end) {
        Vector3d camera = renderer.getCamera().position();
        start = start.sub(camera);
        end = end.sub(camera);
        float lineWidth = this.getParams().getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        RenderLayer renderLayer = OutlineRenderLayers.outlineSolid(true);
        Vector3d diff = end.sub(start);
        if (diff.x() + diff.y() + diff.z() < 0.0) {
            Vector3d temp = start;
            start = end;
            end = temp;
            diff = diff.mul(-1.0);
        }
        Vector3d extension = diff.normalize().mul(lineWidth / 2.0f);
        Vector3d plane = RenderUtils.calculateAxisAlignedPlane(diff);
        Direction face = Direction.getNearest(diff.x(), diff.y(), diff.z());
        Axis axis = face.getAxis();
        start = start.sub(extension);
        end = end.add(extension);
        plane = plane.mul(lineWidth / 2.0f);
        Vector3d a1 = plane.add(start);
        Vector3d b1 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a2 = plane.add(start);
        Vector3d b2 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a3 = plane.add(start);
        Vector3d b3 = plane.add(end);
        plane = RenderUtils.rotate(plane, -90.0, axis);
        Vector3d a4 = plane.add(start);
        Vector3d b4 = plane.add(end);
        if (this.getParams().disableNormals) {
            face = Direction.UP;
            renderer.renderQuad(renderLayer, b4, b3, b2, b1, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            renderer.renderQuad(renderLayer, a1, a2, a3, a4, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            renderer.renderQuad(renderLayer, a1, b1, b2, a2, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            renderer.renderQuad(renderLayer, a2, b2, b3, a3, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            renderer.renderQuad(renderLayer, a3, b3, b4, a4, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            renderer.renderQuad(renderLayer, a4, b4, b1, a1, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
            return;
        }
        renderer.renderQuad(renderLayer, b4, b3, b2, b1, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
        renderer.renderQuad(renderLayer, a1, a2, a3, a4, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face.getOpposite());
        Vector3d vec = a1.sub(a4);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a1, b1, b2, a2, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a2, b2, b3, a3, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a3, b3, b4, a4, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
        vec = RenderUtils.rotate(vec, -90.0, axis);
        face = Direction.getNearest(vec.x(), vec.y(), vec.z());
        renderer.renderQuad(renderLayer, a4, b4, b1, a1, this.getParams().getLightMap(), this.getParams().getColor().getRGB(), face);
    }

    public static class OutlineParams {
        protected Optional<ResourceLocation> faceTexture;
        protected Optional<ResourceLocation> highlightedFaceTexture = Optional.empty();
        protected Direction highlightedFace;
        protected boolean fadeLineWidth = true;
        protected boolean disableCull;
        protected boolean disableNormals;
        protected float alpha = 1.0f;
        protected int lightMap = 0xF000F0;
        protected Color rgb;
        private float lineWidth = 0.03125f;

        public OutlineParams() {
            this.faceTexture = this.highlightedFaceTexture;
            this.rgb = Color.WHITE;
        }

        public OutlineParams colored(float r, float g, float b, float a) {
            this.rgb = new Color(r, g, b, a);
            return this;
        }

        public OutlineParams colored(int red, int green, int blue, int alpha) {
            this.rgb = new Color(red, green, blue, alpha);
            return this;
        }

        public OutlineParams colored(int color) {
            this.rgb = new Color(color, false);
            return this;
        }

        public OutlineParams colored(Color c) {
            this.rgb = c;
            return this;
        }

        public OutlineParams lightMap(int light) {
            this.lightMap = light;
            return this;
        }

        public OutlineParams stroke(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams texture(ResourceLocation location) {
            this.faceTexture = Optional.ofNullable(location);
            return this;
        }

        public OutlineParams clearTextures() {
            return this.textures(null, null);
        }

        public OutlineParams textures(ResourceLocation texture, ResourceLocation highlightTexture) {
            this.faceTexture = Optional.ofNullable(texture);
            this.highlightedFaceTexture = Optional.ofNullable(highlightTexture);
            return this;
        }

        public OutlineParams highlightFace(@Nullable Direction face) {
            this.highlightedFace = face;
            return this;
        }

        public OutlineParams disableNormals() {
            this.disableNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            this.disableCull = true;
            return this;
        }

        public float getLineWidth() {
            return this.fadeLineWidth ? this.alpha * this.lineWidth : this.lineWidth;
        }

        public Direction getHighlightedFace() {
            return this.highlightedFace;
        }

        public int getLightMap() {
            return this.lightMap;
        }

        public Color getColor() {
            return new Color(this.rgb.getRed(), this.rgb.getGreen(), this.rgb.getBlue(), (int)((float)this.rgb.getAlpha() * this.alpha));
        }
    }
}

