/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.renderer.pattern;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.platform.ClientEntrance;
import dev.huskuraft.effortless.api.renderer.RenderFadeEntry;
import dev.huskuraft.effortless.api.renderer.Renderer;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.array.ArrayTransformer;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.renderer.pattern.ArrayTransformerRenderer;
import dev.huskuraft.effortless.renderer.pattern.MirrorTransformerRenderer;
import dev.huskuraft.effortless.renderer.pattern.RadialTransformerRenderer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class PatternRenderer {
    private final Map<UUID, RenderFadeEntry<Context>> entries = Collections.synchronizedMap(new LinkedHashMap());
    private final ClientEntrance entrance;

    public PatternRenderer(ClientEntrance entrance) {
        this.entrance = entrance;
    }

    public EffortlessClient getEntrance() {
        return (EffortlessClient)this.entrance;
    }

    public void tick() {
        Iterator<RenderFadeEntry<Context>> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            RenderFadeEntry<Context> entry = iterator.next();
            entry.tick();
            if (entry.isAlive()) continue;
            iterator.remove();
        }
    }

    public void showPattern(UUID uuid, Context context) {
        this.entries.put(uuid, new RenderFadeEntry<Context>(context));
    }

    public void render(Renderer renderer, float deltaTick) {
        this.entries.forEach((k, v) -> {
            if (!((Context)v.getValue()).pattern().enabled()) {
                return;
            }
            for (Transformer transformer : ((Context)v.getValue()).pattern().transformers()) {
                if (transformer instanceof MirrorTransformer) {
                    MirrorTransformer mirrorTransformer = (MirrorTransformer)transformer;
                    new MirrorTransformerRenderer(this.getEntrance(), mirrorTransformer, true).render(renderer, deltaTick);
                }
                if (transformer instanceof ArrayTransformer) {
                    ArrayTransformer arrayTransformer = (ArrayTransformer)transformer;
                    new ArrayTransformerRenderer(this.getEntrance(), arrayTransformer).render(renderer, deltaTick);
                }
                if (!(transformer instanceof RadialTransformer)) continue;
                RadialTransformer radialTransformer = (RadialTransformer)transformer;
                new RadialTransformerRenderer(this.getEntrance(), radialTransformer, true).render(renderer, deltaTick);
            }
        });
    }
}

