/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.clipboard;

import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.gui.container.AbstractEntryList;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.slot.ItemSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.clipboard.Snapshot;
import dev.huskuraft.effortless.screen.clipboard.StructureSnapshotWidget;
import java.util.UUID;

public final class StructureSnapshotList
extends EditableEntryList<Snapshot> {
    public StructureSnapshotList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    protected SnapshotEntry createHolder(Snapshot Snapshot2) {
        return new SnapshotEntry((Entrance)this.getEntrance(), Snapshot2);
    }

    private static class SnapshotEntry
    extends EditableEntryList.Entry<Snapshot> {
        private StructureSnapshotWidget snapshotWidget;
        private TextWidget textWidget;
        private TextWidget uuidTextWidget;

        public SnapshotEntry(Entrance entrance, Snapshot snapshot) {
            super(entrance, snapshot);
        }

        @Override
        public void onCreate() {
            this.snapshotWidget = this.addWidget(new StructureSnapshotWidget((Entrance)this.getEntrance(), this.getX() + 1, this.getY() + 1, 66, 66, (Snapshot)this.getItem()));
            this.snapshotWidget.setBackgroundColor(-1620284308);
            this.textWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 6 + 66, this.getY() + 4, Text.text("Structure Snapshot")));
            this.uuidTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 6 + 66, this.getY() + 4 + 11, Text.text(UUID.randomUUID().toString()).withStyle(ChatFormatting.GRAY)));
            int xOffset = 0;
            int yOffset = 0;
            for (ItemStack itemStack : ((Snapshot)this.getItem()).getItems()) {
                this.addWidget(new ItemSlot((Entrance)this.getEntrance(), this.getX() + 5 + 66 + xOffset, this.getY() + 4 + 11 + 11 + yOffset, 18, 18, itemStack, Text.text(String.valueOf(itemStack.getCount()))));
                if ((xOffset += 20) <= this.getWidth() - 66 - 5 - 20) continue;
                xOffset = 0;
                yOffset += 20;
            }
        }

        @Override
        public void onReload() {
        }

        @Override
        public int getHeight() {
            if (((AbstractEntryList)this.getParent()).getSelected() == this) {
                return 70 + Math.max((((Snapshot)this.getItem()).getItems().size() + 8) / 9 - 2, 0) * 20;
            }
            return 72;
        }
    }
}

