/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.item;

import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.slot.ItemSlot;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;

public final class ItemStackList
extends EditableEntryList<ItemStack> {
    public ItemStackList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    protected Entry createHolder(ItemStack item) {
        return new Entry((Entrance)this.getEntrance(), item);
    }

    public static class Entry
    extends EditableEntryList.Entry<ItemStack> {
        private ItemSlot itemSlot;
        private TextWidget nameTextWidget;

        public Entry(Entrance entrance, ItemStack itemStack) {
            super(entrance, itemStack);
        }

        @Override
        public void onCreate() {
            this.itemSlot = this.addWidget(new ItemSlot((Entrance)this.getEntrance(), this.getX() + 1, this.getY() + 1, 18, 18, (ItemStack)this.getItem(), Text.empty()));
            this.nameTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 24, this.getY() + 6, this.getDisplayName((ItemStack)this.getItem())));
        }

        @Override
        public void onReload() {
            this.itemSlot.setItemStack((ItemStack)this.item);
            this.nameTextWidget.setMessage(this.getDisplayName((ItemStack)this.item));
        }

        @Override
        public Text getNarration() {
            return Text.translate("narrator.select", this.getDisplayName((ItemStack)this.getItem()));
        }

        @Override
        public int getHeight() {
            return 24;
        }

        private Text getDisplayName(ItemStack itemStack) {
            return itemStack.getHoverName();
        }
    }
}

