/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.pattern;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.MessageTextWidget;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.Pattern;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.building.pattern.mirror.MirrorTransformer;
import dev.huskuraft.effortless.building.pattern.raidal.RadialTransformer;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.screen.transformer.EffortlessItemRandomizerEditScreen;
import dev.huskuraft.effortless.screen.transformer.EffortlessTransformerEditScreen;
import dev.huskuraft.effortless.screen.transformer.EffortlessTransformerPresetsSelectScreen;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.function.Consumer;

public class EffortlessPatternScreen
extends AbstractPanelScreen {
    private final Consumer<Pattern> consumer = pattern -> this.getEntrance().getStructureBuilder().setPattern(this.getEntrance().getClient().getPlayer(), this.pattern);
    private Pattern pattern = this.getEntrance().getStructureBuilder().getContext(this.getEntrance().getClient().getPlayer()).pattern();
    private TextWidget titleTextWidget;
    private TransformerList entries;
    private MessageTextWidget textWidget;
    private Button upButton;
    private Button downButton;
    private Button editButton;
    private Button deleteButton;
    private Button clearButton;
    private Button addButton;
    private Button enableButton;
    private Button doneButton;

    public EffortlessPatternScreen(Entrance entrance) {
        super(entrance, Text.translate("effortless.pattern.title").withStyle(ChatFormatting.DARK_GRAY));
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.setHeight(this.pattern.enabled() ? 238 : 72);
        this.setWidth(this.pattern.enabled() ? 264 : 192);
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.enableButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), this.pattern.enabled() ? Text.translate("effortless.pattern.button.disable") : Text.translate("effortless.pattern.button.enable"), button -> {
            this.pattern = this.pattern.withEnabled(!this.pattern.enabled());
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 48, 0.0f, 0.0f, 1.0f).build());
        this.doneButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.done"), button -> this.detachAll()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 1.0f).build());
        this.entries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 28, this.getWidth() - 12 - 8, this.getHeight() - 18 - 28 - 54));
        this.entries.reset(this.pattern.transformers());
        this.entries.setAlwaysShowScrollbar(true);
        this.textWidget = this.addWidget(new MessageTextWidget(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 28, this.getWidth() - 12, this.getHeight() - 18 - 28 - 54, Text.translate("effortless.pattern.no_transformer"), MessageTextWidget.Gravity.CENTER));
        this.upButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.up"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.moveUpSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.downButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.down"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.moveDownSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.editButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.edit"), button -> {
            if (this.entries.hasSelected()) {
                this.editTransformer((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.delete"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.deleteSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.clearButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.clear"), button -> this.entries.clear()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.25f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.add"), button -> new EffortlessTransformerPresetsSelectScreen((Entrance)this.getEntrance(), transformer -> {
            this.editTransformer(switch (transformer.getType()) {
                case Transformers.MIRROR -> ((MirrorTransformer)transformer.withRandomId()).withPosition(Transformer.roundAllHalf(this.getEntrance().getClient().getPlayer().getPosition()));
                case Transformers.RADIAL -> ((RadialTransformer)transformer.withRandomId()).withPosition(Transformer.roundAllHalf(this.getEntrance().getClient().getPlayer().getPosition()));
                default -> transformer.withRandomId().withName(Text.empty());
            });
            this.onReload();
        }).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.75f, 0.25f).build());
    }

    @Override
    public void onReload() {
        this.pattern = new Pattern(this.pattern.enabled(), this.entries.items());
        this.consumer.accept(this.pattern);
        this.entries.setVisible(this.pattern.enabled());
        this.upButton.setActive(this.entries.hasSelected() && this.entries.indexOfSelected() > 0);
        this.downButton.setActive(this.entries.hasSelected() && this.entries.indexOfSelected() < this.entries.children().size() - 1);
        this.editButton.setActive(this.entries.hasSelected());
        this.deleteButton.setActive(this.entries.hasSelected());
        this.addButton.setActive(this.entries.items().size() < 4);
        this.upButton.setVisible(this.getEntrance().getClient().getWindow().isAltDown() && this.pattern.enabled());
        this.downButton.setVisible(this.getEntrance().getClient().getWindow().isAltDown() && this.pattern.enabled());
        this.editButton.setVisible(!this.getEntrance().getClient().getWindow().isAltDown() && this.pattern.enabled());
        this.deleteButton.setVisible(!this.getEntrance().getClient().getWindow().isAltDown() && this.pattern.enabled());
        this.clearButton.setVisible(this.pattern.enabled());
        this.addButton.setVisible(this.pattern.enabled());
        this.textWidget.setVisible(this.entries.isVisible() && this.entries.items().isEmpty());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            this.editTransformer((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }
    }

    private void editTransformer(Transformer transformer) {
        switch (transformer.getType()) {
            case ARRAY: 
            case MIRROR: 
            case RADIAL: {
                new EffortlessTransformerEditScreen(this.getEntrance(), result -> {
                    if (this.entries.hasSelected()) {
                        this.entries.replaceSelect(result);
                    } else {
                        this.entries.insertSelected(result);
                    }
                    this.onReload();
                }, transformer).attach();
                break;
            }
            case RANDOMIZER: {
                new EffortlessItemRandomizerEditScreen(this.getEntrance(), result -> {
                    if (this.entries.hasSelected()) {
                        this.entries.replaceSelect(result);
                    } else {
                        this.entries.insertSelected(result);
                    }
                    this.onReload();
                }, (ItemRandomizer)transformer).attach();
            }
        }
    }
}

